/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    protected int cacheSizeMax = 1000;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(LRUCache.class.getName()).log(Level.SEVERE, null, ex);
    }

    public LRUCache(int cacheSizeMax) {
        this.cacheSizeMax = cacheSizeMax;
    }

    public int getCacheSizeMax() {
        return this.cacheSizeMax;
    }

    public void setCacheSizeMax(int cacheSizeMax) {
        this.cacheSizeMax = cacheSizeMax;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.cacheSizeMax > 0) {
            return this.size() > this.cacheSizeMax;
        }
        return super.removeEldestEntry(eldest);
    }
}

