/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.map.BasicEventMap;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.SimpleMapAdapter;
import xyz.cofe.collection.set.ClassSet;

public class ClassMap<T>
implements Map<Class, T> {
    private static final Logger logger = Logger.getLogger(ClassMap.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock = new ReentrantLock();
    protected final Map<Class, T> map;
    protected final ClassSet types;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public ClassMap() {
        BasicEventMap<Class, T> emap = new BasicEventMap<Class, T>();
        this.map = emap;
        this.types = new ClassSet(true);
        this.syncTypes(this.types, emap);
    }

    private Closeable syncTypes(final ClassSet types, EventMap<Class, T> map) {
        SimpleMapAdapter mapListener = new SimpleMapAdapter<Class, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void removed(T value, EventMap<Class, T> map, Class key) {
                try {
                    ClassMap.this.lock.lock();
                    if (types != null && key != null) {
                        types.remove(key);
                    }
                }
                finally {
                    ClassMap.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void added(T value, EventMap<Class, T> map, Class key) {
                try {
                    ClassMap.this.lock.lock();
                    if (types != null && key != null) {
                        types.add(key);
                    }
                }
                finally {
                    ClassMap.this.lock.unlock();
                }
            }
        };
        return map.addEventMapListener(mapListener);
    }

    @Override
    public T put(Class key, T value) {
        return this.map.put(key, value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public T get(Class key) {
        return this.map.get(key);
    }

    public T remove(Class key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends Class, ? extends T> m) {
        this.map.putAll(m);
    }

    @Override
    public Set<Class> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Class, T>> entrySet() {
        return this.map.entrySet();
    }

    public T fetch(Class cls) {
        if (cls == null) {
            return null;
        }
        T t = this.map.get(cls);
        if (t != null) {
            return t;
        }
        Collection<Class> matchParents = this.types.getAssignableFrom(cls, true, false);
        LinkedHashSet<Class<Object>> matchedCls = new LinkedHashSet<Class<Object>>();
        if (matchParents != null) {
            for (Class<Object> clazz : matchParents) {
                if (clazz == null) continue;
                matchedCls.add(clazz);
                break;
            }
        }
        for (Class<Object> clazz : matchedCls) {
            t = this.map.get(clazz);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.map.get(key);
    }

    @Override
    public T remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

