/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.map.DeletedMapEvent;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.EventMapListener;
import xyz.cofe.collection.map.InsertedMapEvent;
import xyz.cofe.collection.map.KeyValueMapEvent;
import xyz.cofe.collection.map.MapEvent;
import xyz.cofe.collection.map.MapWrapper;
import xyz.cofe.collection.map.UpdatedMapEvent;
import xyz.cofe.common.GetListenersHelper;
import xyz.cofe.common.ListenersHelper;

public class BasicEventMap<Key, Value>
extends MapWrapper<Key, Value>
implements EventMap<Key, Value>,
GetListenersHelper {
    protected final Queue<KeyValueMapEvent<Key, Value>> eventQueue = new LinkedList<KeyValueMapEvent<Key, Value>>();
    protected final ListenersHelper<EventMapListener, MapEvent> listeners = new ListenersHelper<EventMapListener, MapEvent>(new Func2<Object, EventMapListener, MapEvent>(){

        @Override
        public Object apply(EventMapListener lst, MapEvent e) {
            lst.eventMap(e);
            return null;
        }
    });

    public BasicEventMap() {
        this(new LinkedHashMap());
    }

    public BasicEventMap(Map<Key, Value> wrappedMap) {
        super(wrappedMap);
    }

    public Lock getListenersLock() {
        return this.listeners.getLock();
    }

    protected boolean listenObjectChanged() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToQueue(KeyValueMapEvent<Key, Value> event) {
        Queue<KeyValueMapEvent<Key, Value>> queue = this.eventQueue;
        synchronized (queue) {
            this.addEventToQueue0(event);
        }
    }

    private void addEventToQueue0(KeyValueMapEvent<Key, Value> event) {
        if (event != null) {
            this.eventQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireQueueEvents() {
        Queue<KeyValueMapEvent<Key, Value>> queue = this.eventQueue;
        synchronized (queue) {
            this.fireQueueEvents0();
        }
    }

    private void fireQueueEvents0() {
        KeyValueMapEvent<Key, Value> event;
        while ((event = this.eventQueue.poll()) != null) {
            this.listeners.fireEvent(event);
        }
    }

    @Override
    public ListenersHelper getListenersHelper() {
        return this.listeners;
    }

    @Override
    public Closeable addEventMapListener(EventMapListener<Key, Value> listener) {
        return this.addEventMapListener(listener, false);
    }

    @Override
    public Closeable addEventMapListener(EventMapListener<Key, Value> listener, boolean weakRef) {
        return this.listeners.addListener(listener, weakRef);
    }

    @Override
    public void removeEventMapListener(EventMapListener<Key, Value> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean containsEventMapListener(EventMapListener<Key, Value> listener) {
        return this.listeners.hasListener(listener);
    }

    @Override
    public Closeable onChanged(Func3<Object, ? super Key, ? super Value, ? super Value> fn) {
        return this.onChanged(fn, false);
    }

    @Override
    public Closeable onChanged(final Func3<Object, ? super Key, ? super Value, ? super Value> fn, boolean weak) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.addEventMapListener(new EventMapListener<Key, Value>(){

            @Override
            public void eventMap(MapEvent<Key, Value> event) {
                if (event instanceof UpdatedMapEvent) {
                    UpdatedMapEvent e = (UpdatedMapEvent)event;
                    fn.apply(e.getKey(), e.getOldValue(), e.getValue());
                } else if (event instanceof InsertedMapEvent) {
                    InsertedMapEvent inserted = (InsertedMapEvent)event;
                    fn.apply(inserted.getKey(), null, inserted.getValue());
                } else if (event instanceof DeletedMapEvent) {
                    DeletedMapEvent deleted = (DeletedMapEvent)event;
                    fn.apply(deleted.getKey(), deleted.getValue(), null);
                }
            }
        });
    }

    @Override
    public Closeable onUpdated(Func3<Object, ? super Key, ? super Value, ? super Value> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onUpdated(fn, false);
    }

    @Override
    public Closeable onUpdated(final Func3<Object, ? super Key, ? super Value, ? super Value> fn, boolean weak) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onChanged(new Func3<Object, Key, Value, Value>(){

            @Override
            public Object apply(Key k, Value oldv, Value newv) {
                if (newv != null && oldv != null) {
                    fn.apply(k, oldv, newv);
                }
                return null;
            }
        }, weak);
    }

    @Override
    public Closeable onInserted(Func3<Object, ? super Key, ? super Value, ? super Value> fn) {
        return this.onInserted(fn, false);
    }

    @Override
    public Closeable onInserted(final Func3<Object, ? super Key, ? super Value, ? super Value> fn, boolean weak) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onChanged(new Func3<Object, Key, Value, Value>(){

            @Override
            public Object apply(Key k, Value oldv, Value newv) {
                if (newv != null && oldv == null) {
                    fn.apply(k, oldv, newv);
                }
                return null;
            }
        }, weak);
    }

    @Override
    public Closeable onDeleted(Func3<Object, ? super Key, ? super Value, ? super Value> fn) {
        return this.onDeleted(fn, false);
    }

    @Override
    public Closeable onDeleted(final Func3<Object, ? super Key, ? super Value, ? super Value> fn, boolean weak) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onChanged(new Func3<Object, Key, Value, Value>(){

            @Override
            public Object apply(Key k, Value oldv, Value newv) {
                if (newv == null && oldv != null) {
                    fn.apply(k, oldv, newv);
                }
                return null;
            }
        }, weak);
    }

    protected void fireEvent(MapEvent event) {
        this.listeners.fireEvent(event);
    }

    protected void fireDeleted(Key k, Value v) {
        this.fireEvent(this.createDeleted(k, v));
    }

    protected DeletedMapEvent<Key, Value> createDeleted(Key k, Value v) {
        return new DeletedMapEvent<Key, Value>(this, k, v);
    }

    protected void fireInserted(Key k, Value v) {
        this.fireEvent(this.createInserted(k, v));
    }

    protected InsertedMapEvent<Key, Value> createInserted(Key k, Value v) {
        return new InsertedMapEvent<Key, Value>(this, k, v);
    }

    protected void fireUpdated(Key k, Value v, Value old) {
        this.fireEvent(this.createUpdated(k, v, old));
    }

    protected UpdatedMapEvent<Key, Value> createUpdated(Key k, Value v, Value old) {
        return new UpdatedMapEvent<Key, Value>(this, k, v, old);
    }

    protected Object lockRun(Func0 run) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        Object r = run.apply();
        return r;
    }

    protected Object lockRun(Func0 run, LockMethod method) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        return this.lockRun(run);
    }

    @Override
    public void clear() {
        this.lockRun(new Func0(){

            public Object apply() {
                BasicEventMap.this.clear0();
                return null;
            }
        }, new LockMethod("clear", true));
        this.fireQueueEvents();
    }

    private void clear0() {
        for (Key k : this.keySet()) {
            Value v = this.get(k);
            Key fk = k;
            this.addEventToQueue(this.createDeleted(fk, v));
        }
        super.clear();
    }

    @Override
    public Value put(final Key key, final Value value) {
        Object r = this.lockRun(new Func0(){

            public Object apply() {
                Object r = BasicEventMap.this.put0(key, value);
                return r;
            }
        }, new LockMethod("put", true));
        this.fireQueueEvents();
        return (Value)r;
    }

    private Value put0(Key key, Value value) {
        if (this.containsKey(key)) {
            Key k = key;
            Value vnew = value;
            Value res = super.put(key, value);
            this.addEventToQueue(this.createUpdated(k, vnew, res));
            return res;
        }
        Key k = key;
        Value v = value;
        Value res = super.put(key, value);
        this.addEventToQueue(this.createInserted(k, v));
        return res;
    }

    private boolean throwExceptionOnNullArg() {
        return true;
    }

    @Override
    public void putAll(final Map<? extends Key, ? extends Value> m) {
        this.lockRun(new Func0(){

            public Object apply() {
                BasicEventMap.this.putAll0(m);
                return null;
            }
        }, new LockMethod("putAll", true));
        this.fireQueueEvents();
    }

    private void putAll0(Map<? extends Key, ? extends Value> m) {
        if (m == null) {
            if (this.throwExceptionOnNullArg()) {
                throw new IllegalArgumentException("m == null");
            }
            return;
        }
        for (Key k : m.keySet()) {
            Value v = m.get(k);
            this.put0(k, v);
        }
    }

    @Override
    public Value remove(final Object key) {
        Object r = this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.this.remove0(key);
            }
        }, new LockMethod("remove", true));
        this.fireQueueEvents();
        return (Value)r;
    }

    private Value remove0(Object key) {
        if (this.containsKey(key)) {
            try {
                Value v = this.get(key);
                Object k = key;
                this.addEventToQueue(this.createDeleted(k, v));
            }
            catch (ClassCastException v) {
                // empty catch block
            }
        }
        Object res = super.remove(key);
        return res;
    }

    protected boolean sendNewListOnNewWrapperMap() {
        return true;
    }

    @Override
    public void setWrappedMap(final Map<Key, Value> wrappedMap) {
        this.lockRun(new Func0(){

            public Object apply() {
                BasicEventMap.this.setWrappedMap0(wrappedMap);
                return null;
            }
        }, new LockMethod("setWrappedMap", true));
        this.fireQueueEvents();
    }

    private void setWrappedMap0(Map<Key, Value> wrappedMap) {
        if (wrappedMap == null) {
            if (this.throwExceptionOnNullArg()) {
                throw new IllegalArgumentException("wrappedMap == null");
            }
            return;
        }
        if (this.sendNewListOnNewWrapperMap()) {
            Value v;
            for (Key k : this.keySet()) {
                v = this.get(k);
                Key fk = k;
                this.addEventToQueue(this.createDeleted(k, v));
            }
            for (Key key : wrappedMap.keySet()) {
                v = this.get(key);
                Key k = key;
                this.addEventToQueue(this.createInserted(k, v));
            }
        }
        super.setWrappedMap(wrappedMap);
    }

    @Override
    public boolean isEmpty() {
        boolean res = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.isEmpty();
            }
        }, new LockMethod("isEmpty", false));
        return res;
    }

    @Override
    public boolean containsKey(final Object key) {
        boolean res = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.containsKey(key);
            }
        }, new LockMethod("containsKey", false));
        return res;
    }

    @Override
    public boolean containsValue(final Object value) {
        boolean res = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.containsValue(value);
            }
        }, new LockMethod("containsValue", false));
        return res;
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        Set res = (Set)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.entrySet();
            }
        }, new LockMethod("entrySet", false));
        return res;
    }

    @Override
    public Value get(final Object key) {
        Object res = this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.get(key);
            }
        }, new LockMethod("get", false));
        return (Value)res;
    }

    @Override
    public Set<Key> keySet() {
        Set res = (Set)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.keySet();
            }
        }, new LockMethod("keySet", false));
        return res;
    }

    @Override
    public int size() {
        int res = (Integer)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.size();
            }
        }, new LockMethod("size", false));
        return res;
    }

    @Override
    public Collection<Value> values() {
        Collection res = (Collection)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.values();
            }
        }, new LockMethod("values", false));
        return res;
    }

    @Override
    public Map<Key, Value> getWrappedMap() {
        Map res = (Map)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventMap.super.getWrappedMap();
            }
        }, new LockMethod("getWrappedMap", false));
        return res;
    }
}

