/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.list.AddedPositionalEvent;
import xyz.cofe.collection.list.AddingPositionalEvent;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.IndexIterator;
import xyz.cofe.collection.list.RemovedPositionalEvent;
import xyz.cofe.collection.list.RemovingPositionalEvent;

public class IndexEventList<E>
extends BasicEventList<E> {
    public IndexEventList() {
        this(new ArrayList());
    }

    public IndexEventList(List<E> list) throws NullPointerException {
        super(list);
    }

    @Override
    public boolean add(final E e) {
        Func0 fn = new Func0(){

            public Object apply() {
                return IndexEventList.this.add0(e);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("add", true));
        this.fireQueueEvents();
        return res;
    }

    @Override
    protected boolean add0(E e) {
        int size = this.getWrappedList().size();
        AddingPositionalEvent<E> inserting = new AddingPositionalEvent<E>(e, this, size);
        this.addEventToQueue(inserting);
        this.fireQueueEvents();
        boolean res = this.getWrappedList().add(e);
        if (res) {
            int pos = this.getWrappedList().size() - 1;
            AddedPositionalEvent<E> inserted = new AddedPositionalEvent<E>(e, this, pos);
            this.addEventToQueue(inserted);
        }
        return res;
    }

    @Override
    public boolean remove(final Object o) {
        Func0 fn = new Func0(){

            public Object apply() {
                return IndexEventList.this.remove0(o);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("remove", true));
        this.fireQueueEvents();
        return res;
    }

    @Override
    protected boolean remove0(Object o) {
        boolean res;
        int index = this.getWrappedList().indexOf(o);
        if (index >= 0) {
            this.addEventToQueue(new RemovingPositionalEvent<Object>(o, this, index));
            this.fireQueueEvents();
        }
        if (res = this.getWrappedList().remove(o)) {
            this.addEventToQueue(new RemovedPositionalEvent<Object>(o, this, index));
        }
        return res;
    }

    @Override
    public E remove(final int index) {
        Func0 fn = new Func0(){

            public Object apply() {
                IndexEventList.this.remove0(index);
                return null;
            }
        };
        Object item = this.lockRun(fn, new LockMethod("remove", true));
        this.fireQueueEvents();
        return (E)item;
    }

    @Override
    protected E remove0(int index) {
        this.addEventToQueue(new RemovingPositionalEvent(this.get(index), this, index));
        this.fireQueueEvents();
        Object item = this.getWrappedList().remove(index);
        this.addEventToQueue(new RemovedPositionalEvent(item, this, index));
        return item;
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        Func0 fn = new Func0(){

            public Object apply() {
                return IndexEventList.this.removeAll0(c);
            }
        };
        boolean modified = (Boolean)this.lockRun(fn, new LockMethod("removeAll", true));
        this.fireQueueEvents();
        return modified;
    }

    @Override
    protected boolean removeAll0(Collection<?> c) {
        if (c == null) {
            return false;
        }
        int idx = 0;
        for (Object e : this.toArray()) {
            if (c.contains(e)) {
                this.addEventToQueue(new RemovingPositionalEvent<Object>(e, this, idx));
                this.fireQueueEvents();
                this.getWrappedList().remove(idx);
                this.addEventToQueue(new RemovedPositionalEvent<Object>(e, this, idx));
                this.fireQueueEvents();
                continue;
            }
            ++idx;
        }
        return true;
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        Func0 fn = new Func0(){

            public Object apply() {
                return IndexEventList.this.retainAll0(c);
            }
        };
        boolean modified = (Boolean)this.lockRun(fn, new LockMethod("removeAll", true));
        this.fireQueueEvents();
        return modified;
    }

    @Override
    protected boolean retainAll0(Collection<?> c) {
        if (c == null) {
            return false;
        }
        int idx = -1;
        TreeSet<Integer> removeIndexes = new TreeSet<Integer>();
        for (E e : this) {
            ++idx;
            if (c.contains(e)) continue;
            removeIndexes.add(idx);
        }
        Iterator ridxitr = removeIndexes.descendingIterator();
        while (ridxitr.hasNext()) {
            int ridx = (Integer)ridxitr.next();
            this.remove(ridx);
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        Func0 fn = new Func0(){

            public Object apply() {
                return IndexEventList.this.iterator0();
            }
        };
        Iterator itr = (Iterator)this.lockRun(fn, new LockMethod("iterator", false));
        this.fireQueueEvents();
        return itr;
    }

    @Override
    protected Iterator<E> iterator0() {
        IndexEventList f_elist = this;
        Iterator f_itr = this.getWrappedList().iterator();
        return new IndexIterator(f_elist, f_itr);
    }
}

