/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.ArrayDeque;
import java.util.Iterator;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.iterators.MutableTreeWalk;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkType;

public class TreeWalkItreator<T>
implements Iterator<TreeWalk<T>> {
    private ArrayDeque<MutableTreeWalk<T>> nodesQueue = null;
    private NodesExtracter<T, T> extracter = null;
    private TreeWalkType walkType = TreeWalkType.ByBranchForward;
    private Predicate<T> nodePredicate = null;
    private Predicate<TreeWalk<T>> walkPredicate = null;

    public static <T> Iterable<TreeWalk<T>> createIterable(T startNode, NodesExtracter<T, T> extracter) {
        final T fstartNode = startNode;
        final NodesExtracter<T, T> fextracter = extracter;
        return new Iterable<TreeWalk<T>>(){

            @Override
            public Iterator<TreeWalk<T>> iterator() {
                return new TreeWalkItreator<Object>(fstartNode, fextracter);
            }
        };
    }

    public static <T> Iterable<TreeWalk<T>> createIterable(T startNode, NodesExtracter<T, T> extracter, TreeWalkType walkType) {
        final T fstartNode = startNode;
        final NodesExtracter<T, T> fextracter = extracter;
        final TreeWalkType fWalkType = walkType;
        return new Iterable<TreeWalk<T>>(){

            @Override
            public Iterator<TreeWalk<T>> iterator() {
                return new TreeWalkItreator<Object>(fstartNode, fextracter, 0, 1, fWalkType, null, null);
            }
        };
    }

    public static <T> Iterable<TreeWalk<T>> createIterable(T startNode, NodesExtracter<T, T> extracter, Predicate<TreeWalk<T>> walkPredicate) {
        final T fstartNode = startNode;
        final NodesExtracter<T, T> fextracter = extracter;
        final Predicate<TreeWalk<T>> fwalkPredicate = walkPredicate;
        return new Iterable<TreeWalk<T>>(){

            @Override
            public Iterator<TreeWalk<T>> iterator() {
                return new TreeWalkItreator<Object>(fstartNode, fextracter, 0, 1, TreeWalkType.ByBranchForward, null, fwalkPredicate);
            }
        };
    }

    public static <T> Iterable<TreeWalk<T>> createIterable(T startNode, NodesExtracter<T, T> extracter, Predicate<TreeWalk<T>> walkPredicate, TreeWalkType walkType) {
        final T fstartNode = startNode;
        final NodesExtracter<T, T> fextracter = extracter;
        final Predicate<TreeWalk<T>> fwalkPredicate = walkPredicate;
        final TreeWalkType fWalkType = walkType;
        return new Iterable<TreeWalk<T>>(){

            @Override
            public Iterator<TreeWalk<T>> iterator() {
                return new TreeWalkItreator<Object>(fstartNode, fextracter, 0, 1, fWalkType, null, fwalkPredicate);
            }
        };
    }

    public TreeWalkItreator(T startNode, NodesExtracter<T, T> extracter) {
        this(startNode, extracter, 0, 1, TreeWalkType.ByBranchForward, null, null);
    }

    public TreeWalkItreator(T startNode, NodesExtracter<T, T> extracter, int startLevel, int levelStep, TreeWalkType walkType, Predicate<T> nodePredicate, Predicate<TreeWalk<T>> walkPredicate) {
        if (startNode == null) {
            throw new IllegalArgumentException("startNode == null");
        }
        if (extracter == null) {
            throw new IllegalArgumentException("extracter == null");
        }
        this.extracter = extracter;
        if (walkType == null) {
            walkType = TreeWalkType.ByBranchForward;
        }
        this.walkType = walkType;
        this.nodesQueue = new ArrayDeque();
        this.nodePredicate = nodePredicate;
        this.walkPredicate = walkPredicate;
        boolean add = true;
        if (nodePredicate != null && !nodePredicate.validate(startNode)) {
            add = false;
        }
        MutableTreeWalk<T> mtw = new MutableTreeWalk<T>(startNode, startLevel, levelStep);
        if (walkPredicate != null && !walkPredicate.validate(mtw)) {
            add = false;
        }
        if (add) {
            this.nodesQueue.add(mtw);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.nodesQueue.isEmpty();
    }

    @Override
    public TreeWalk<T> next() {
        switch (this.walkType) {
            case ByLevel: {
                return this.topDown();
            }
            case ByBranchBackward: {
                return this.deepParentChildBack();
            }
            case ByBranchForward: {
                return this.deepParentChildForward();
            }
        }
        return this.deepParentChildForward();
    }

    private TreeWalk<T> deepParentChildForward() {
        if (this.nodesQueue.isEmpty()) {
            return null;
        }
        MutableTreeWalk<T> result = this.nodesQueue.poll();
        T currentNode = result.currentNode();
        int step = result.stepLevel();
        Iterable<T> nodes = this.extracter.extract(currentNode);
        if (nodes != null) {
            nodes = Iterators.reverse(nodes);
        }
        if (nodes != null) {
            int idx = -1;
            MutableTreeWalk<T> mtw = null;
            for (T n : nodes) {
                if (this.nodePredicate != null && !this.nodePredicate.validate(n)) continue;
                mtw = new MutableTreeWalk<T>(result, n, result.currentLevel() + step, step);
                if (this.walkPredicate != null && !this.walkPredicate.validate(mtw)) continue;
                mtw.setChildIndex(++idx);
                if (idx == 0) {
                    mtw.setFirstChild(true);
                }
                this.nodesQueue.addFirst(mtw);
            }
            if (mtw != null) {
                mtw.setLastChild(true);
            }
        }
        return result;
    }

    private TreeWalk<T> deepParentChildBack() {
        if (this.nodesQueue.isEmpty()) {
            return null;
        }
        MutableTreeWalk<T> result = this.nodesQueue.poll();
        T currentNode = result.currentNode();
        int step = result.stepLevel();
        Iterable<T> nodes = this.extracter.extract(currentNode);
        if (nodes != null) {
            int idx = -1;
            MutableTreeWalk<T> mtw = null;
            for (T n : nodes) {
                if (this.nodePredicate != null && !this.nodePredicate.validate(n)) continue;
                mtw = new MutableTreeWalk<T>(result, n, result.currentLevel() + step, step);
                if (this.walkPredicate != null && !this.walkPredicate.validate(mtw)) continue;
                mtw.setChildIndex(++idx);
                if (idx == 0) {
                    mtw.setFirstChild(true);
                }
                this.nodesQueue.addFirst(mtw);
            }
            if (mtw != null) {
                mtw.setLastChild(true);
            }
        }
        return result;
    }

    private TreeWalk<T> topDown() {
        if (this.nodesQueue.isEmpty()) {
            return null;
        }
        MutableTreeWalk<T> result = this.nodesQueue.poll();
        T currentNode = result.currentNode();
        int step = result.stepLevel();
        Iterable<T> nodes = this.extracter.extract(currentNode);
        if (nodes != null) {
            int idx = -1;
            MutableTreeWalk<T> mtw = null;
            for (T n : nodes) {
                if (this.nodePredicate != null && !this.nodePredicate.validate(n)) continue;
                mtw = new MutableTreeWalk<T>(result, n, result.currentLevel() + step, step);
                if (this.walkPredicate != null && !this.walkPredicate.validate(mtw)) continue;
                mtw.setChildIndex(++idx);
                if (idx == 0) {
                    mtw.setFirstChild(true);
                }
                this.nodesQueue.add(mtw);
            }
            if (mtw != null) {
                mtw.setLastChild(true);
            }
        }
        return result;
    }

    @Override
    public void remove() {
    }
}

