/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import xyz.cofe.collection.NodesExtracter;

public class SimpleTreeIterator<T>
implements Iterator<T> {
    private NodesExtracter extracter = null;
    private T src = null;
    private boolean readSelf = false;
    private Iterator<T> children = null;
    private Iterator<T> deep = null;
    private T current = null;

    public SimpleTreeIterator(T src, NodesExtracter<T, T> extract) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (extract == null) {
            throw new IllegalArgumentException("extract == null");
        }
        this.src = src;
        this.extracter = extract;
        this.go();
    }

    private void go() {
        this.current = this.findNext();
    }

    private T findNext() {
        if (!this.readSelf) {
            this.readSelf = true;
            Iterable i = this.extracter.extract(this.src);
            if (i != null) {
                this.children = i.iterator();
            }
            return this.src;
        }
        if (this.deep != null && this.deep.hasNext()) {
            return this.deep.next();
        }
        if (this.children != null && this.children.hasNext()) {
            while (this.children.hasNext()) {
                T child = this.children.next();
                if (child != null) {
                    this.deep = new SimpleTreeIterator<T>(child, this.extracter);
                    return this.deep.next();
                }
                this.deep = null;
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public T next() {
        if (this.current != null) {
            T result = this.current;
            this.current = this.findNext();
            return result;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

