/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.ArrayList;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.iterators.TreeWalk;

public class MutableTreeWalk<T>
implements TreeWalk<T> {
    protected Iterable<TreeWalk<T>> walkPath = null;
    private Convertor<TreeWalk<T>, T> convertor2node = new Convertor<TreeWalk<T>, T>(){

        @Override
        public T convert(TreeWalk<T> from) {
            return from.currentNode();
        }
    };
    protected TreeWalk<T> parent = null;
    protected T currentNode = null;
    protected int currentLevel = 0;
    protected T parentNode = null;
    protected T startNode = null;
    protected int startLevel = 0;
    protected int stepLevel = 1;
    protected boolean firstChild = false;
    protected boolean lastChild = false;
    protected int childIndex = -1;

    public MutableTreeWalk(TreeWalk<T> parentTreeWalk, T currentNode, int currentLevel, int stepLevel) {
        this.parent = parentTreeWalk;
        this.currentNode = currentNode;
        this.currentLevel = currentLevel;
        this.stepLevel = stepLevel;
        if (parentTreeWalk != null) {
            this.parentNode = parentTreeWalk.currentNode();
        }
        ArrayList<TreeWalk<T>> _path = new ArrayList<TreeWalk<T>>();
        TreeWalk<T> n = this;
        _path.add(n);
        while (n.parent() != null) {
            TreeWalk prnt = n.parent();
            _path.add(0, prnt);
            n = prnt;
        }
        if (this.parent != null && _path != null && _path.size() > 0) {
            this.startNode = _path.get(0).currentNode();
            this.startLevel = _path.get(0).startLevel();
        }
        this.walkPath = _path;
    }

    public MutableTreeWalk(T startNode, int startLevel, int stepLevel) {
        this.currentNode = startNode;
        this.parentNode = null;
        this.startNode = startNode;
        this.currentLevel = startLevel;
        this.startLevel = startLevel;
        this.stepLevel = stepLevel;
        this.walkPath = Iterators.single(this);
    }

    @Override
    public Iterable<TreeWalk<T>> walkPath() {
        return this.walkPath;
    }

    @Override
    public Iterable<T> nodePath() {
        return Iterators.convert(this.walkPath, this.convertor2node);
    }

    @Override
    public TreeWalk<T> parent() {
        return this.parent;
    }

    @Override
    public T currentNode() {
        return this.currentNode;
    }

    public void currentNode(T newCurrentNode) {
        this.currentNode = newCurrentNode;
    }

    @Override
    public int currentLevel() {
        return this.currentLevel;
    }

    public void currentLevel(int newCurrentLevel) {
        this.currentLevel = newCurrentLevel;
    }

    @Override
    public T parentNode() {
        return this.parentNode;
    }

    public void parentNode(T newParentNode) {
        this.parentNode = newParentNode;
    }

    @Override
    public T startNode() {
        return this.startNode;
    }

    public void startNode(T newStartNode) {
        this.startNode = newStartNode;
    }

    @Override
    public int startLevel() {
        return this.startLevel;
    }

    public void startLevel(int newStartLevel) {
        this.startLevel = newStartLevel;
    }

    @Override
    public int stepLevel() {
        return this.stepLevel;
    }

    public void stepLevel(int newStepLevel) {
        this.stepLevel = newStepLevel;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public void setChildIndex(int childIndex) {
        this.childIndex = childIndex;
    }

    public boolean isFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(boolean firstChild) {
        this.firstChild = firstChild;
    }

    public boolean isLastChild() {
        return this.lastChild;
    }

    public void setLastChild(boolean lastChild) {
        this.lastChild = lastChild;
    }
}

