/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import java.util.ArrayList;
import xyz.cofe.collection.graph.BasicGraphEvent;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.GraphAction;
import xyz.cofe.collection.graph.GraphEvent;
import xyz.cofe.collection.graph.GraphFactory;
import xyz.cofe.collection.graph.GraphListener;
import xyz.cofe.collection.graph.GraphSender;
import xyz.cofe.collection.graph.SimpleSDGraph;

public class SimpleSDGraphSender<N, E>
extends SimpleSDGraph<N, E>
implements GraphSender<N, E> {
    private ArrayList<GraphListener> listeners = new ArrayList();

    public SimpleSDGraphSender() {
    }

    public SimpleSDGraphSender(GraphFactory<N, E> factory) {
        super(factory);
    }

    @Override
    public void addGraphListener(GraphListener<N, E> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeGraphListener(GraphListener<N, E> listener) {
        this.listeners.remove(listener);
    }

    protected void fireGraphEvent(GraphEvent<N, E> event) {
        for (GraphListener listener : this.listeners) {
            listener.graphEvent(event);
        }
    }

    @Override
    protected void onEdgeAdded(Edge<N, E> es) {
        this.fireGraphEvent(new BasicGraphEvent<Object, E>(this, GraphAction.EDGE_ADDED, null, es));
    }

    @Override
    protected void onNodeAdded(N node) {
        this.fireGraphEvent(new BasicGraphEvent(this, GraphAction.NODE_ADDED, node, null));
    }

    @Override
    protected void onEdgeRemoved(Edge<N, E> es) {
        this.fireGraphEvent(new BasicGraphEvent<Object, E>(this, GraphAction.EDGE_REMOVED, null, es));
    }

    @Override
    protected void onNodeRemoved(N node) {
        this.fireGraphEvent(new BasicGraphEvent(this, GraphAction.NODE_REMOVED, node, null));
    }
}

