/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.cofe.cbuffer.page.PageEvent;

public interface PageListener {
    public void pageEvent(PageEvent var1);

    public static class PageListenerSupport {
        private final Collection<PageListener> listeners = new CopyOnWriteArraySet<PageListener>();

        public void addListener(PageListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener==null");
            }
            this.listeners.add(listener);
        }

        public void removeListener(PageListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener==null");
            }
            this.listeners.remove(listener);
        }

        public boolean hasListener(PageListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener==null");
            }
            return this.listeners.contains(listener);
        }

        public void fire(PageEvent event) {
            for (PageListener ls : this.listeners) {
                ls.pageEvent(event);
            }
        }
    }
}

