/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import xyz.cofe.cbuffer.page.CacheMap;
import xyz.cofe.cbuffer.page.PageError;
import xyz.cofe.cbuffer.page.PageEvent;
import xyz.cofe.cbuffer.page.PageListener;
import xyz.cofe.cbuffer.page.Paged;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Fn1;

public class CachePaged<CACHEPAGES extends Paged & ResizablePages, PERSISTPAGES extends Paged & ResizablePages>
implements Paged,
ResizablePages {
    private final PageListener.PageListenerSupport listeners = new PageListener.PageListenerSupport();
    private final CacheMap cacheMap;
    private final CACHEPAGES cache;
    private final PERSISTPAGES persistent;
    private final Map<Integer, ReadWriteLock> persistentPageLocks = new HashMap<Integer, ReadWriteLock>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void addListener(PageListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(PageListener listener) {
        this.listeners.removeListener(listener);
    }

    public boolean hasListener(PageListener listener) {
        return this.listeners.hasListener(listener);
    }

    public void fire(PageEvent event) {
        this.listeners.fire(event);
    }

    public CachePaged(CACHEPAGES cache, PERSISTPAGES persistent) {
        if (cache == null) {
            throw new IllegalArgumentException("cache==null");
        }
        if (persistent == null) {
            throw new IllegalArgumentException("persistent==null");
        }
        if (cache.memoryInfo().pageCount() < 1) {
            throw new IllegalArgumentException("cache.memoryInfo().pageCount()<1");
        }
        if (persistent.memoryInfo().pageCount() < cache.memoryInfo().pageCount()) {
            throw new IllegalArgumentException("persistent.memoryInfo().pageCount()<cache.memoryInfo().pageCount()");
        }
        if (cache.memoryInfo().pageSize() != persistent.memoryInfo().pageSize()) {
            throw new PageError("pageSize different between cache and persistent");
        }
        this.cache = cache;
        this.persistent = persistent;
        this.cacheMap = new CacheMap();
        this.cacheMap.resize(cache.memoryInfo().pageCount(), req -> this.flushCachePage(req.cachedPageIndex, req.persistentPageIndex));
        this.cacheMap.addListener(this.listeners::fire);
    }

    public void resizeCachePages(int pages) {
        if (pages < 1) {
            throw new IllegalArgumentException("pages<1");
        }
        this.writeLock(() -> {
            if (pages > this.persistent.memoryInfo().pageCount()) {
                throw new IllegalArgumentException("pages > persistent.memoryInfo().pageCount()");
            }
            this.cacheMap.writeLock(() -> {
                this.cacheMap.resize(pages, ev -> this.flushCachePage(ev.cachedPageIndex, ev.persistentPageIndex));
                ((ResizablePages)this.cache).resizePages(pages);
            });
        });
    }

    @Override
    public ResizablePages.ResizedPages resizePages(int pages) {
        if (pages < 1) {
            throw new IllegalArgumentException("pages<1");
        }
        return this.writeLock(() -> this.cacheMap.writeLock(() -> {
            UsedPagesInfo before = this.memoryInfo().clone();
            if (this.cacheMap.size() > pages) {
                this.cacheMap.resize(pages, ev -> this.flushCachePage(ev.cachedPageIndex, ev.persistentPageIndex));
                ((ResizablePages)this.cache).resizePages(pages);
            }
            ((ResizablePages)this.persistent).resizePages(pages);
            UsedPagesInfo after = this.memoryInfo().clone();
            return new ResizablePages.ResizedPages(before, after);
        }));
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public int getCacheSize() {
        return this.cacheMap.size();
    }

    public CACHEPAGES getCache() {
        return this.cache;
    }

    public PERSISTPAGES getPersistent() {
        return this.persistent;
    }

    private void flushCachePage(int cachePage, int persistentPageIndex) {
        this.persistent.writePage(persistentPageIndex, this.cache.readPage(cachePage));
        this.fire(new FlushCachePage(cachePage, persistentPageIndex));
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        return this.persistent.memoryInfo();
    }

    @Override
    public byte[] readPage(int page) {
        return this.readLock(() -> this.readPersistentLock(page, () -> {
            Optional fromCache = this.cacheMap.findPersistentPageForRead(page, (Fn1 & Serializable)cp -> cp.readLock(() -> {
                this.fire(new CacheHit(page, true));
                cp.markReads();
                return this.cache.readPage(cp.cachePageIndex);
            }));
            if (fromCache.isPresent()) {
                return (byte[])fromCache.get();
            }
            this.fire(new CacheMiss(page, true));
            AtomicReference<Object> result = new AtomicReference<Object>(null);
            this.cacheMap.allocate(cp -> cp.writeLock(() -> {
                cp.unTarget();
                byte[] data = this.persistent.readPage(page);
                this.fire(new PageLoaded(page, data));
                this.cache.writePage(cp.cachePageIndex, data);
                this.fire(new CacheWrote(page, cp.cachePageIndex, data));
                cp.setDataSize(data.length);
                cp.assignTarget(page);
                cp.markMapped();
                result.set(data);
            }), fr -> fr.cachePage.readLock(() -> {
                this.flushCachePage(fr.cachedPageIndex, fr.persistentPageIndex);
                fr.cachePage.markFlushed();
            }));
            byte[] bytes = result.get();
            if (bytes == null) {
                throw new PageError("data not loaded, not allocated");
            }
            return bytes;
        }));
    }

    @Override
    public void writePage(int page, byte[] data2write) {
        this.readLock(() -> this.writePersistentLock(page, () -> {
            if (this.cacheMap.findPersistentPageForWrite(page, (Fn1 & Serializable)cachePage -> cachePage.writeLock(() -> {
                Integer max;
                this.fire(new CacheHit(page, false));
                byte[] dataToWrite = data2write;
                if (cachePage.getDataSize().isPresent() && data2write.length > (max = cachePage.getDataSize().get())) {
                    dataToWrite = Arrays.copyOf(data2write, (int)max);
                }
                this.cache.writePage(cachePage.cachePageIndex, dataToWrite);
                this.fire(new CacheWrote(page, cachePage.cachePageIndex, dataToWrite));
                cachePage.markWrote();
                return true;
            })).orElse(false).booleanValue()) {
                return;
            }
            this.fire(new CacheMiss(page, false));
            AtomicBoolean allocated = new AtomicBoolean(false);
            this.cacheMap.allocate(cp -> cp.writeLock(() -> {
                cp.unTarget();
                byte[] data2persist = this.persistent.readPage(page);
                this.fire(new PageLoaded(page, data2persist));
                byte[] data2write2 = data2write;
                if (data2write2.length < data2persist.length) {
                    System.arraycopy(data2write, 0, data2persist, 0, data2write.length);
                    data2write2 = data2persist;
                } else if (data2write2.length > data2persist.length) {
                    throw new PageError("destination out of rage, persistent size = " + data2persist.length + " write size = " + data2write.length);
                }
                this.cache.writePage(cp.cachePageIndex, data2write2);
                this.fire(new CacheWrote(page, cp.cachePageIndex, data2write2));
                cp.setDataSize(data2write2.length);
                cp.assignTarget(page);
                cp.markMapped();
                cp.markWrote();
                allocated.set(true);
            }), fr -> fr.cachePage.readLock(() -> {
                this.flushCachePage(fr.cachedPageIndex, fr.persistentPageIndex);
                fr.cachePage.markFlushed();
            }));
            if (!allocated.get()) {
                throw new PageError("page not allocated in cache");
            }
        }));
    }

    @Override
    public void updatePage(int page, Fn1<byte[], byte[]> update) {
        if (update == null) {
            throw new IllegalArgumentException("update==null");
        }
        this.readLock(() -> this.writePersistentLock(page, () -> {
            if (this.cacheMap.findPersistentPageForWrite(page, (Fn1 & Serializable)cp -> cp.writeLock(() -> {
                this.fire(new CacheHit(page, false));
                byte[] cacheData = this.cache.readPage(cp.cachePageIndex);
                cp.markReads();
                byte[] newData = (byte[])update.apply((Object)cacheData);
                this.cache.writePage(cp.cachePageIndex, newData);
                this.fire(new CacheWrote(page, cp.cachePageIndex, newData));
                cp.markWrote();
                return true;
            })).orElse(false).booleanValue()) {
                return;
            }
            this.fire(new CacheMiss(page, false));
            AtomicBoolean allocated = new AtomicBoolean(false);
            this.cacheMap.allocate(cp -> cp.writeLock(() -> {
                cp.unTarget();
                byte[] persistData = this.persistent.readPage(page);
                this.fire(new PageLoaded(page, persistData));
                byte[] updatedData = (byte[])update.apply((Object)persistData);
                this.cache.writePage(cp.cachePageIndex, updatedData);
                this.fire(new CacheWrote(page, cp.cachePageIndex, updatedData));
                cp.setDataSize(updatedData.length);
                cp.assignTarget(page);
                cp.markMapped();
                cp.markWrote();
                allocated.set(true);
            }), fr -> fr.cachePage.readLock(() -> {
                this.flushCachePage(fr.cachedPageIndex, fr.persistentPageIndex);
                fr.cachePage.markFlushed();
            }));
            if (!allocated.get()) {
                throw new PageError("page not allocated in cache");
            }
        }));
    }

    public void flush() {
        this.writeLock(() -> this.cacheMap.flush(ev -> {
            this.flushCachePage(ev.cachedPageIndex, ev.persistentPageIndex);
            ev.cachePage.markFlushed();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReadWriteLock> persistentLocks(int ... pages) {
        HashSet<ReadWriteLock> lockSet = new HashSet<ReadWriteLock>();
        Map<Integer, ReadWriteLock> map = this.persistentPageLocks;
        synchronized (map) {
            for (int p : pages) {
                int persistentPageLocksMax = 64;
                lockSet.add(this.persistentPageLocks.computeIfAbsent(p % persistentPageLocksMax, x -> new ReentrantReadWriteLock()));
            }
        }
        return new ArrayList<ReadWriteLock>(lockSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReadWriteLock> persistentLocks(int fromPage, int toPageExc) {
        HashSet<ReadWriteLock> lockSet = new HashSet<ReadWriteLock>();
        Map<Integer, ReadWriteLock> map = this.persistentPageLocks;
        synchronized (map) {
            for (int p = Math.min(fromPage, toPageExc); p < Math.max(fromPage, toPageExc); ++p) {
                int persistentPageLocksMax = 64;
                lockSet.add(this.persistentPageLocks.computeIfAbsent(p % persistentPageLocksMax, x -> new ReentrantReadWriteLock()));
            }
        }
        return new ArrayList<ReadWriteLock>(lockSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R readPersistentLock(int page, Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(page);
        try {
            locks.forEach(lck -> lck.readLock().lock());
            R r = code.get();
            return r;
        }
        finally {
            locks.forEach(lck -> lck.readLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R readPersistentLock(int[] pages, Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(pages);
        try {
            locks.forEach(lck -> lck.readLock().lock());
            R r = code.get();
            return r;
        }
        finally {
            locks.forEach(lck -> lck.readLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R readPersistentLock(int fromPage, int toPageExc, Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(fromPage, toPageExc);
        try {
            locks.forEach(lck -> lck.readLock().lock());
            R r = code.get();
            return r;
        }
        finally {
            locks.forEach(lck -> lck.readLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentLock(int page, Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(page);
        try {
            locks.forEach(lck -> lck.writeLock().lock());
            code.run();
        }
        finally {
            locks.forEach(lck -> lck.writeLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R writePersistentLock(int page, Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(page);
        try {
            locks.forEach(lck -> lck.writeLock().lock());
            R r = code.get();
            return r;
        }
        finally {
            locks.forEach(lck -> lck.writeLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentLock(int[] pages, Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(pages);
        try {
            locks.forEach(lck -> lck.writeLock().lock());
            code.run();
        }
        finally {
            locks.forEach(lck -> lck.writeLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentLock(int fromPage, int toPageExc, Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(fromPage, toPageExc);
        try {
            locks.forEach(lck -> lck.writeLock().lock());
            code.run();
        }
        finally {
            locks.forEach(lck -> lck.writeLock().unlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R writePersistentLock(int[] pages, Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<ReadWriteLock> locks = this.persistentLocks(pages);
        try {
            locks.forEach(lck -> lck.writeLock().lock());
            R r = code.get();
            return r;
        }
        finally {
            locks.forEach(lck -> lck.writeLock().unlock());
        }
    }

    public <R> R readLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void readLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public <R> R writeLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void writeLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public static class CacheWrote
    implements PageEvent {
        public final int persistentPageIndex;
        public final int cachePageIndex;
        public final byte[] data;

        public CacheWrote(int persistentPageIndex, int cachePageIndex, byte[] data) {
            this.persistentPageIndex = persistentPageIndex;
            this.cachePageIndex = cachePageIndex;
            this.data = data;
        }

        public String toString() {
            return "CacheWrote{persistentPageIndex=" + this.persistentPageIndex + ", cachePageIndex=" + this.cachePageIndex + "}";
        }
    }

    public static class PageLoaded
    implements PageEvent {
        public final int persistentPageIndex;
        public final byte[] data;

        public PageLoaded(int persistentPageIndex, byte[] data) {
            this.persistentPageIndex = persistentPageIndex;
            this.data = data;
        }

        public String toString() {
            return "PageLoaded{persistentPageIndex=" + this.persistentPageIndex + "}";
        }
    }

    public static class CacheHit
    implements PageEvent {
        public final int persistentPageIndex;
        public final boolean read;

        public CacheHit(int persistentPageIndex, boolean read) {
            this.persistentPageIndex = persistentPageIndex;
            this.read = read;
        }

        public String toString() {
            return "CacheHit{persistentPageIndex=" + this.persistentPageIndex + ", read=" + this.read + "}";
        }
    }

    public static class CacheMiss
    implements PageEvent {
        public final int persistentPageIndex;
        public final boolean read;

        public CacheMiss(int persistentPageIndex, boolean read) {
            this.persistentPageIndex = persistentPageIndex;
            this.read = read;
        }

        public String toString() {
            return "CacheMiss{persistentPageIndex=" + this.persistentPageIndex + ", read=" + this.read + "}";
        }
    }

    public static class FlushCachePage
    implements PageEvent {
        public final int cachePage;
        public final int persistentPageIndex;

        public FlushCachePage(int cachePage, int persistentPageIndex) {
            this.cachePage = cachePage;
            this.persistentPageIndex = persistentPageIndex;
        }

        public String toString() {
            return "FlushCachePage{cachePage=" + this.cachePage + ", persistentPageIndex=" + this.persistentPageIndex + "}";
        }
    }
}

