/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import xyz.cofe.cbuffer.page.PageEvent;
import xyz.cofe.cbuffer.page.PageListener;

public class CachePage {
    private final PageListener.PageListenerSupport listeners = new PageListener.PageListenerSupport();
    public final int cachePageIndex;
    public volatile Integer target;
    private volatile boolean dirty;
    private volatile Integer dataSize;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void addListener(PageListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(PageListener listener) {
        this.listeners.removeListener(listener);
    }

    public boolean hasListener(PageListener listener) {
        return this.listeners.hasListener(listener);
    }

    public void fire(PageEvent event) {
        this.listeners.fire(event);
    }

    public CachePage(int cachePageIndex) {
        this.cachePageIndex = cachePageIndex;
    }

    public Optional<Integer> getTarget() {
        Integer t = this.target;
        return t != null ? Optional.of(t) : Optional.empty();
    }

    public Optional<Integer> assignTarget(int target) {
        Optional<Integer> old = this.getTarget();
        this.target = target;
        this.fire(new AssignTarget(this));
        return old;
    }

    public Optional<Integer> unTarget() {
        Optional<Integer> old = this.getTarget();
        this.target = null;
        this.dirty = false;
        this.fire(new UnTarget(this, old));
        return old;
    }

    public void markMapped() {
        this.dirty = false;
        this.fire(new MarkMapped(this));
    }

    public void markReads() {
        this.fire(new MarkReads(this));
    }

    public void markWrote() {
        this.dirty = true;
        this.fire(new MarkWrote(this));
    }

    public void markFlushed() {
        this.dirty = false;
        this.fire(new MarkFlushed(this));
    }

    boolean hasTarget() {
        return this.target != null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Optional<Integer> getDataSize() {
        return this.dataSize != null ? Optional.of(this.dataSize) : Optional.empty();
    }

    public void resetDataSize() {
        this.dataSize = null;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
        this.fire(new SetDataSize(this));
    }

    public String toString() {
        return "CachePage { idx=" + this.cachePageIndex + ", target=" + this.target + ", dirty=" + this.dirty + ", dataSize=" + this.dataSize + " }";
    }

    public <R> R readLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void readLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public <R> R writeLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void writeLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public static class SetDataSize
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public SetDataSize(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "SetDataSize{page=" + this.page + "}";
        }
    }

    public static class MarkFlushed
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public MarkFlushed(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "MarkFlushed{page=" + this.page + "}";
        }
    }

    public static class MarkWrote
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public MarkWrote(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "MarkWrote{page=" + this.page + "}";
        }
    }

    public static class MarkReads
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public MarkReads(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "MarkReads{page=" + this.page + "}";
        }
    }

    public static class MarkMapped
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public MarkMapped(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "MarkMapped{page=" + this.page + "}";
        }
    }

    public static class UnTarget
    implements CachePageEvent {
        public final CachePage page;
        public final Optional<Integer> persistentPageIndex;

        @Override
        public CachePage page() {
            return this.page;
        }

        public UnTarget(CachePage page, Optional<Integer> persistentPageIndex) {
            this.page = page;
            this.persistentPageIndex = persistentPageIndex;
        }

        public String toString() {
            return "UnTarget{page=" + this.page + ", persistentPageIndex=" + this.persistentPageIndex + "}";
        }
    }

    public static class AssignTarget
    implements CachePageEvent {
        public final CachePage page;

        @Override
        public CachePage page() {
            return this.page;
        }

        public AssignTarget(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "AssignTarget{page=" + this.page + "}";
        }
    }

    public static interface CachePageEvent
    extends PageEvent {
        public CachePage page();
    }
}

