/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import xyz.cofe.cbuffer.page.CachePage;
import xyz.cofe.cbuffer.page.PageEvent;
import xyz.cofe.cbuffer.page.PageListener;
import xyz.cofe.fn.Fn1;
import xyz.cofe.fn.Tuple2;

public class CacheMap {
    private final PageListener.PageListenerSupport listeners = new PageListener.PageListenerSupport();
    public final List<CachePage> cachePages = new ArrayList<CachePage>();
    private final PageListener popupEvent = this.listeners::fire;
    private final PageListener mapPersistent2cache = event -> {};
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void addListener(PageListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(PageListener listener) {
        this.listeners.removeListener(listener);
    }

    public boolean hasListener(PageListener listener) {
        return this.listeners.hasListener(listener);
    }

    public void fire(PageEvent event) {
        this.listeners.fire(event);
    }

    public int size() {
        return this.readLock(this.cachePages::size);
    }

    public void resize(int newSize, Consumer<FlushRequest> flushing) {
        this.writeLock(() -> {
            if (newSize < 0) {
                throw new IllegalArgumentException("newSize<0");
            }
            if (flushing == null) {
                throw new IllegalArgumentException("flushing==null");
            }
            if (this.cachePages.size() == newSize) {
                return;
            }
            if (this.cachePages.size() < newSize) {
                int extend = newSize - this.cachePages.size();
                int fromIdx = this.cachePages.size();
                for (int i = 0; i < extend; ++i) {
                    CachePage cachePage = new CachePage(fromIdx + i);
                    cachePage.addListener(this.popupEvent);
                    cachePage.addListener(this.mapPersistent2cache);
                    this.cachePages.add(cachePage);
                }
            } else {
                int reduceSize = this.cachePages.size() - newSize;
                ArrayList<Tuple2> reduceList = new ArrayList<Tuple2>(reduceSize);
                for (int i = this.cachePages.size() - 1; i >= 0; --i) {
                    reduceList.add(Tuple2.of((Object)i, (Object)this.cachePages.get(i)));
                }
                for (Tuple2 cp : reduceList) {
                    if (((CachePage)cp.b()).isDirty() && ((CachePage)cp.b()).getTarget().isPresent()) {
                        flushing.accept(new FlushRequest((Integer)cp.a(), (CachePage)cp.b()));
                    }
                    this.cachePages.remove((Integer)cp.a());
                    ((CachePage)cp.b()).removeListener(this.popupEvent);
                    ((CachePage)cp.b()).removeListener(this.mapPersistent2cache);
                }
            }
        });
    }

    public Find find(Predicate<CachePage> what) {
        if (what == null) {
            throw new IllegalArgumentException("what==null");
        }
        return new Find(what);
    }

    public <R> Optional<R> findPersistentPageForRead(int persistentPage, Fn1<CachePage, R> process) {
        return this.readLock(() -> {
            if (process == null) {
                throw new IllegalArgumentException("process==null");
            }
            for (CachePage cp : this.cachePages) {
                if (!Objects.equals(cp.target, persistentPage)) continue;
                return Optional.of(process.apply((Object)cp));
            }
            return Optional.empty();
        });
    }

    public <R> Optional<R> findPersistentPageForWrite(int persistentPage, Fn1<CachePage, R> process) {
        return this.readLock(() -> {
            if (process == null) {
                throw new IllegalArgumentException("process==null");
            }
            for (CachePage cp : this.cachePages) {
                if (!Objects.equals(cp.target, persistentPage)) continue;
                return Optional.of(process.apply((Object)cp));
            }
            return Optional.empty();
        });
    }

    public void allocate(Consumer<CachePage> consumer, Consumer<FlushRequest> flushing) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer==null");
        }
        if (flushing == null) {
            throw new IllegalArgumentException("flushing==null");
        }
        this.readLock(() -> {
            List<CachePage> unmapped = this.findUnmapped();
            if (!unmapped.isEmpty()) {
                CachePage en = unmapped.iterator().next();
                this.fire(new AllocatedUnmapped(en));
                consumer.accept(en);
                return;
            }
            List<CachePage> dirtyPages = this.findDirty();
            if (!dirtyPages.isEmpty()) {
                if (dirtyPages.size() == 1) {
                    CachePage cp = dirtyPages.get(0);
                    this.fire(new AllocatedDirty(cp));
                    flushing.accept(new FlushRequest(cp.getTarget().get(), cp));
                    consumer.accept(cp);
                } else {
                    CachePage cp = dirtyPages.get(ThreadLocalRandom.current().nextInt(dirtyPages.size()));
                    this.fire(new AllocatedDirty(cp));
                    flushing.accept(new FlushRequest(cp.getTarget().get(), cp));
                    consumer.accept(cp);
                }
                return;
            }
            if (this.cachePages.size() > 0) {
                CachePage cp = this.cachePages.get(ThreadLocalRandom.current().nextInt(this.cachePages.size()));
                if (cp.getTarget().isPresent() && cp.isDirty()) {
                    flushing.accept(new FlushRequest(cp.getTarget().get(), cp));
                }
                this.fire(new AllocatedCleaned(cp));
                consumer.accept(cp);
            }
        });
    }

    private List<CachePage> findUnmapped() {
        return this.find(cp -> cp.getTarget().isEmpty()).go();
    }

    private List<CachePage> findDirty() {
        return this.find(cp -> cp.getTarget().isPresent() && cp.isDirty()).go();
    }

    public void flush(Consumer<FlushRequest> flushing) {
        if (flushing == null) {
            throw new IllegalArgumentException("flushing==null");
        }
        this.readLock(() -> {
            List<CachePage> dirtyPages = this.findDirty();
            dirtyPages.forEach(cp -> {
                if (cp.isDirty() && cp.getTarget().isPresent()) {
                    flushing.accept(new FlushRequest(cp.getTarget().get(), (CachePage)cp));
                }
            });
        });
    }

    public List<CachePage> dirtyPages() {
        return this.readLock(() -> {
            ArrayList<CachePage> list = new ArrayList<CachePage>();
            for (CachePage cp : this.cachePages) {
                if (!cp.isDirty() || !cp.getTarget().isPresent()) continue;
                list.add(cp);
            }
            return list;
        });
    }

    public <R> R readLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void readLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public <R> R writeLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void writeLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public static class AllocatedCleaned
    implements PageEvent {
        public final CachePage page;

        public AllocatedCleaned(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "AllocatedCleaned{page=" + this.page + "}";
        }
    }

    public static class AllocatedDirty
    implements PageEvent {
        public final CachePage page;

        public AllocatedDirty(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "AllocatedDirty{page=" + this.page + "}";
        }
    }

    public static class AllocatedUnmapped
    implements PageEvent {
        public final CachePage page;

        public AllocatedUnmapped(CachePage page) {
            this.page = page;
        }

        public String toString() {
            return "AllocatedUnmapped{page=" + this.page + "}";
        }
    }

    public class Find {
        public final Predicate<CachePage> what;

        public Find(Predicate<CachePage> what) {
            this.what = what;
        }

        public List<CachePage> go() {
            return CacheMap.this.readLock(() -> {
                ArrayList<CachePage> pages = new ArrayList<CachePage>();
                for (CachePage cp : CacheMap.this.cachePages) {
                    if (!this.what.test(cp)) continue;
                    pages.add(cp);
                }
                return pages;
            });
        }
    }

    public static class FlushRequest {
        public final int cachedPageIndex;
        public final int persistentPageIndex;
        public final CachePage cachePage;

        public FlushRequest(int persistentPageIndex, CachePage cachePage) {
            this.cachedPageIndex = cachePage.cachePageIndex;
            this.persistentPageIndex = persistentPageIndex;
            this.cachePage = cachePage;
        }
    }
}

