/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.Flushable;
import xyz.cofe.cbuffer.page.PageError;
import xyz.cofe.cbuffer.page.Paged;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;

public class CBuffPaged
implements Flushable,
Paged,
ResizablePages {
    protected final ContentBuffer cbuff;
    protected final int pageSize;
    protected volatile long maxSize = -1L;
    protected boolean resizeable = false;

    public CBuffPaged(ContentBuffer cbuff, int pageSize, boolean resizeable, long maxSize) {
        if (cbuff == null) {
            throw new IllegalArgumentException("cbuff==null");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (maxSize > 1L && maxSize % (long)pageSize > 0L) {
            throw new IllegalArgumentException("maxSize not aligned by pageSize");
        }
        this.pageSize = pageSize;
        this.cbuff = cbuff;
        this.maxSize = maxSize;
        this.resizeable = resizeable;
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        long c;
        long total;
        long l = total = this.maxSize >= 0L ? Math.min(this.cbuff.getSize(), this.maxSize) : this.cbuff.getSize();
        if (total <= 0L) {
            return UsedPagesInfo.of(0, 0, 0);
        }
        long pc = total / (long)this.pageSize;
        if (pc > Integer.MAX_VALUE) {
            throw new IllegalStateException("pageCount more than Integer.MAX_VALUE");
        }
        long pc_1 = total % (long)this.pageSize;
        long l2 = c = pc_1 > 0L ? pc + 1L : pc;
        if (c > Integer.MAX_VALUE) {
            throw new IllegalStateException("pageCount more than Integer.MAX_VALUE");
        }
        return UsedPagesInfo.of(this.pageSize, (int)c, (int)(pc_1 == 0L ? (long)this.pageSize : pc_1));
    }

    @Override
    public byte[] readPage(int page) {
        long total;
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        long l = total = this.maxSize >= 0L ? Math.min(this.cbuff.getSize(), this.maxSize) : this.cbuff.getSize();
        if (total <= 0L) {
            return new byte[0];
        }
        int pages = this.memoryInfo().pageCount();
        if (page >= pages) {
            return new byte[0];
        }
        long off = (long)page * (long)this.pageSize;
        long avail = total - off;
        if (avail <= 0L) {
            return new byte[0];
        }
        int avail_i = avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        int read = Math.min(avail_i, this.pageSize);
        return this.cbuff.get(off, read);
    }

    @Override
    public void writePage(int page, byte[] data) {
        long total;
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (data.length < 1) {
            return;
        }
        if (data.length > this.pageSize) {
            throw new IllegalArgumentException("data.length(=" + data.length + ") > pageSize(=" + this.pageSize + ")");
        }
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        long l = total = this.maxSize >= 0L ? Math.min(this.cbuff.getSize(), this.maxSize) : this.cbuff.getSize();
        if (total <= 0L) {
            throw new PageError("pages not exists");
        }
        int pages = this.memoryInfo().pageCount();
        if (page >= pages) {
            if (!this.resizeable) {
                throw new PageError("can't resize to " + (page + 1) + " pages; not resizeable");
            }
            long targetSize = (long)pages * (long)this.pageSize + (long)data.length;
            if (targetSize > this.maxSize && this.maxSize >= 0L) {
                throw new PageError("can't resize to " + (page + 1) + " pages; limit by maxSize(=" + this.maxSize + ")");
            }
            long currSize = this.cbuff.getSize();
            if (currSize < targetSize) {
                this.cbuff.setSize(targetSize);
            }
        }
        long off = (long)page * (long)this.pageSize;
        if (data.length < this.pageSize) {
            byte[] buff = this.cbuff.get(off, this.pageSize);
            System.arraycopy(data, 0, buff, 0, data.length);
            this.cbuff.set(off, buff, 0, buff.length);
        } else {
            this.cbuff.set(off, data, 0, data.length);
        }
    }

    @Override
    public void flush() {
        this.cbuff.flush();
    }

    @Override
    public ResizablePages.ResizedPages resizePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (!this.resizeable) {
            throw new IllegalStateException("not resizeable");
        }
        if (pages == 0) {
            UsedPagesInfo before = this.memoryInfo().clone();
            this.cbuff.setSize(0L);
            return new ResizablePages.ResizedPages(before, this.memoryInfo().clone());
        }
        UsedPagesInfo before = this.memoryInfo().clone();
        this.cbuff.setSize((long)this.pageSize * (long)pages);
        UsedPagesInfo after = this.memoryInfo().clone();
        return new ResizablePages.ResizedPages(before, after);
    }
}

