/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;

public class SBCBuffer
implements AutoCloseable,
ContentBuffer {
    private static final Logger logger = Logger.getLogger(SBCBuffer.class.getName());
    protected SeekableByteChannel channel;
    protected boolean closeOnFinalize = false;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(SBCBuffer.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(SBCBuffer.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SBCBuffer.class.getName(), method, result);
    }

    public SBCBuffer(SeekableByteChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        this.channel = channel;
    }

    public SeekableByteChannel getChannel() {
        return this.channel;
    }

    @Override
    public synchronized void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
            this.channel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        SBCBuffer sBCBuffer = this;
        synchronized (sBCBuffer) {
            if (this.closeOnFinalize) {
                this.close();
            }
        }
        super.finalize();
    }

    @Override
    public synchronized long getSize() {
        try {
            if (this.channel == null) {
                throw new IllegalStateException("buffer is closed");
            }
            return this.channel.size();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    @Override
    public synchronized void setSize(long size) {
        if (this.channel == null) {
            throw new IllegalStateException("buffer is closed");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size < 0");
        }
        long cursize = size;
        if (cursize > size) {
            try {
                this.channel.truncate(size);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        if (cursize < size) {
            try {
                if (size > 0L) {
                    this.channel.position(size - 1L);
                    byte b0 = 0;
                    byte[] barr = new byte[]{b0};
                    this.channel.write(ByteBuffer.wrap(barr));
                }
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
    }

    @Override
    public synchronized void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (this.channel == null) {
            throw new IllegalStateException("buffer is closed");
        }
        if (offset < 0L) {
            throw new IllegalStateException("offset<0");
        }
        if (data == null) {
            throw new IllegalStateException("data == null");
        }
        if (dataOffset < 0) {
            throw new IllegalStateException("dataOffset<0");
        }
        if (dataLen < 0) {
            throw new IllegalStateException("dataLen<0");
        }
        if (dataOffset + dataLen > data.length) {
            throw new IllegalStateException("dataOffset(" + dataOffset + ")+dataLen(" + dataLen + ")>data.length(" + data.length + ")");
        }
        try {
            this.channel.position(offset);
            this.channel.write(ByteBuffer.wrap(data, dataOffset, dataLen));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    @Override
    public synchronized byte[] get(long offset, int dataLen) {
        if (this.channel == null) {
            throw new IllegalStateException("buffer is closed");
        }
        if (dataLen < 0) {
            throw new IllegalStateException("dataLen<0");
        }
        if (offset < 0L) {
            throw new IllegalStateException("offset<0");
        }
        if (dataLen == 0) {
            return new byte[0];
        }
        try {
            this.channel.position(offset);
            ByteBuffer bb = ByteBuffer.allocate(dataLen);
            int readed = this.channel.read(bb);
            if (readed <= 0) {
                return new byte[0];
            }
            bb.position(0);
            byte[] data = bb.array();
            if (readed < dataLen) {
                return Arrays.copyOf(data, readed);
            }
            return data;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        if (this.channel == null) {
            throw new IllegalStateException("buffer is closed");
        }
        SBCBuffer sBCBuffer = this;
        synchronized (sBCBuffer) {
            try {
                this.channel.truncate(0L);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
    }

    public synchronized ContentBuffer clone() {
        if (this.channel == null) {
            throw new IllegalStateException("buffer is closed");
        }
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    public synchronized void flush() {
    }
}

