/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public class SlowPagedData
implements ResizablePages<UsedPagesInfo> {
    protected final ResizablePages<UsedPagesInfo> target;
    protected final long delay;

    public SlowPagedData(ResizablePages resizablePages, long delay) {
        if (resizablePages == null) {
            throw new IllegalArgumentException("resizablePages==null");
        }
        this.target = resizablePages;
        this.delay = delay;
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        return this.target.extendPages(pages);
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        return this.target.memoryInfo();
    }

    @Override
    public byte[] readPage(int page) {
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.target.readPage(page);
    }

    @Override
    public void writePage(int page, byte[] data) {
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.target.writePage(page, data);
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        return this.target.reducePages(pages);
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> resizePages(int pages) {
        return this.target.resizePages(pages);
    }
}

