/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.page.ExtendablePages;
import xyz.cofe.cbuffer.page.PagedData;
import xyz.cofe.cbuffer.page.ReduciblePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public interface ResizablePages<MEM extends UsedPagesInfo>
extends PagedData<MEM>,
ReduciblePages<MEM>,
ExtendablePages<MEM> {
    default public Tuple2<UsedPagesInfo, UsedPagesInfo> resizePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of(this.memoryInfo(), this.memoryInfo());
        }
        long curPageCnt = this.memoryInfo().pageCount();
        long nxtPageCnt = curPageCnt + (long)pages;
        long diffPgeCnt = nxtPageCnt - curPageCnt;
        if (diffPgeCnt > 0L) {
            if (diffPgeCnt > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("can't extend over " + diffPgeCnt + ", Integer.MAX_VALUE");
            }
            return this.extendPages((int)diffPgeCnt);
        }
        long abs_diff = -diffPgeCnt;
        if (abs_diff > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can't reduce over " + abs_diff + ", Integer.MAX_VALUE");
        }
        return this.reducePages((int)abs_diff);
    }
}

