/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import xyz.cofe.cbuffer.page.Distance;
import xyz.cofe.cbuffer.page.Duration;
import xyz.cofe.cbuffer.page.OperationData;
import xyz.cofe.fn.Consumer3;
import xyz.cofe.fn.Tuple2;

public class CycleOperationData<DATA, DURATION extends Comparable<DURATION> & Duration<DURATION>, TIME extends Comparable<TIME> & Distance<TIME, DURATION>>
implements OperationData<DATA, DURATION, TIME> {
    protected List<DATA> dataList;
    protected List<TIME> beginList;
    protected List<TIME> endList;
    protected Map<DATA, Integer> counts;
    protected Map<DATA, DURATION> duration;
    protected Map<DATA, TIME> beginLastTime;
    protected Map<DATA, TIME> endLastTime;
    protected int limit;
    protected long ptr;

    public CycleOperationData(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit<1");
        }
        this.dataList = new ArrayList<DATA>();
        this.beginList = new ArrayList<TIME>();
        this.endList = new ArrayList<TIME>();
        this.ptr = 0L;
        this.limit = limit;
        this.counts = new HashMap<DATA, Integer>();
        this.duration = new HashMap<DATA, DURATION>();
        this.beginLastTime = new HashMap<DATA, TIME>();
        this.endLastTime = new HashMap<DATA, TIME>();
    }

    @Override
    public Map<DATA, Integer> counts() {
        return this.counts;
    }

    @Override
    public Map<DATA, DURATION> duration() {
        return this.duration;
    }

    @Override
    public Optional<Tuple2<TIME, TIME>> last(DATA data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        Comparable begin = (Comparable)this.beginLastTime.get(data);
        Comparable end = (Comparable)this.endLastTime.get(data);
        if (begin == null || end == null) {
            return Optional.empty();
        }
        return Optional.of(Tuple2.of((Object)begin, (Object)end));
    }

    private <T> Optional<T> collect(List<T> list, int trgt, T value) {
        if (list.size() <= trgt) {
            int addBefore = trgt - list.size();
            for (int i = 0; i < addBefore; ++i) {
                list.add(value);
            }
            list.add(value);
            return Optional.empty();
        }
        return Optional.of(list.set(trgt, value));
    }

    @Override
    public void collect(TIME begin, TIME end, DATA data) {
        if (begin == null) {
            throw new IllegalArgumentException("begin==null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end==null");
        }
        int cmp1 = begin.compareTo(end);
        if (cmp1 > 0) {
            throw new IllegalArgumentException("begin > end");
        }
        int trgt = (int)(this.ptr % (long)this.limit);
        Optional<DATA> prevData = this.collect(this.dataList, trgt, data);
        Optional<TIME> prevBegin = this.collect(this.beginList, trgt, begin);
        Optional<TIME> prevEnd = this.collect(this.endList, trgt, end);
        ++this.ptr;
        this.beginLastTime.put(data, begin);
        this.endLastTime.put(data, end);
        this.counts.put(data, this.counts.getOrDefault(data, 0) + 1);
        Object zeroDuration = ((Distance)begin).distance(begin);
        Comparable d = (Comparable)this.duration.getOrDefault(data, zeroDuration);
        d = (Comparable)((Duration)((Object)d)).add(((Distance)end).distance(begin));
        this.duration.put(data, d);
        if (prevData.isPresent() && prevEnd.isPresent() && prevBegin.isPresent()) {
            DATA p_data = prevData.get();
            Comparable p_begin = (Comparable)prevBegin.get();
            Comparable p_end = (Comparable)prevEnd.get();
            int cnt = this.counts.getOrDefault(p_data, 0);
            if (cnt > 0) {
                if (--cnt <= 0) {
                    this.counts.remove(p_data);
                    this.duration.remove(p_data);
                } else {
                    this.counts.put(p_data, cnt);
                    Object d1 = ((Distance)((Object)p_end)).distance(p_begin);
                    Comparable d2 = (Comparable)this.duration.get(p_data);
                    if (d2 != null) {
                        Comparable d3 = (Comparable)((Duration)((Object)d2)).sub(d1);
                        if (zeroDuration.compareTo((Comparable)d3) > 0) {
                            this.duration.remove(p_data);
                        } else {
                            this.duration.put(p_data, d3);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void read(Consumer3<TIME, TIME, DATA> data) {
        int i;
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        int trgt = (int)(this.ptr % (long)this.limit);
        if (this.dataList.size() != this.beginList.size()) {
            return;
        }
        if (this.dataList.size() != this.endList.size()) {
            return;
        }
        int size = this.dataList.size();
        if ((long)trgt < this.ptr) {
            for (i = trgt; i < size; ++i) {
                data.accept((Object)((Comparable)this.beginList.get(i)), (Object)((Comparable)this.endList.get(i)), this.dataList.get(i));
            }
        }
        for (i = 0; i < trgt; ++i) {
            data.accept((Object)((Comparable)this.beginList.get(i)), (Object)((Comparable)this.endList.get(i)), this.dataList.get(i));
        }
    }
}

