/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import xyz.cofe.cbuffer.Flushable;
import xyz.cofe.cbuffer.page.CachePagedState;
import xyz.cofe.cbuffer.page.DirtyPagedDataBase;
import xyz.cofe.cbuffer.page.DirtyPagedState;
import xyz.cofe.cbuffer.page.IntArrayReadOnly;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Consumer1;
import xyz.cofe.fn.Tuple2;

public class CachePagedDataBase<S extends CachePagedState<M, D>, M extends UsedPagesInfo, D extends DirtyPagedDataBase<M, ? extends DirtyPagedState>>
implements ResizablePages<M>,
Flushable {
    protected final S state;

    protected CachePagedDataBase(S state) {
        if (state == null) {
            throw new IllegalArgumentException("state==null");
        }
        this.state = state;
    }

    protected CachePagedDataBase(D cachePages, ResizablePages<M> persistentPages, S state) {
        if (cachePages == null) {
            throw new IllegalArgumentException("cachePages==null");
        }
        if (persistentPages == null) {
            throw new IllegalArgumentException("hardPages==null");
        }
        if (((DirtyPagedDataBase)cachePages).memoryInfo().pageSize() != persistentPages.memoryInfo().pageSize()) {
            throw new IllegalArgumentException("different page size between cachePages and hardPages");
        }
        if (state == null) {
            throw new IllegalArgumentException("state==null");
        }
        this.state = state;
        this.state.cachePages(cachePages);
        this.state.persistentPages(persistentPages);
        int pc = ((DirtyPagedDataBase)cachePages).memoryInfo().pageCount();
        int[] cache2prst = new int[pc];
        Arrays.fill(cache2prst, -1);
        this.state.cache2prst_replace(arr -> cache2prst);
        this.state.prst2cache(new HashMap<Integer, Integer>());
    }

    public CachePagedDataBase(D cachePages, ResizablePages<M> persistentPages) {
        this(cachePages, persistentPages, CachePagedState.nonSafe());
    }

    public Tuple2<Long, Long> cacheHitMiss() {
        return this.state.statCacheHitMiss();
    }

    protected boolean isClosed() {
        return this.state.isClosed();
    }

    @Override
    public M memoryInfo() {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        return (M)this.state.persistentPages().memoryInfo();
    }

    protected int persist2cache(int persistPage) {
        if (persistPage < 0) {
            throw new IllegalArgumentException("persistPage<0");
        }
        Integer c_i = this.state.prst2cache_read(map -> (Integer)map.get(persistPage));
        return c_i != null ? c_i : -1;
    }

    protected int cache2persist(int cachePage) {
        this.arg_cachePage_range(cachePage);
        return this.state.cache2prst_read(arr -> arr.get(cachePage));
    }

    protected int cache2persist_mut(int cachePage) {
        this.arg_cachePage_range(cachePage);
        return this.state.cache2prst_read(arr -> arr.get(cachePage));
    }

    private void arg_cachePage_range(int cachePage) {
        if (cachePage < 0) {
            throw new IllegalArgumentException("cachePage out of range: cachePage<0");
        }
        int cnt = this.state.cache2prst_read(IntArrayReadOnly::length);
        if (cachePage >= cnt) {
            throw new IllegalArgumentException("cachePage out of range: cachePage>=cache2prst.length");
        }
    }

    protected boolean dirty(int cachePage) {
        this.arg_cachePage_range(cachePage);
        return ((DirtyPagedDataBase)this.state.cachePages()).dirty(cachePage);
    }

    protected boolean dirty_mut(int cachePage) {
        this.arg_cachePage_range(cachePage);
        return ((DirtyPagedDataBase)this.state.cachePages()).dirty(cachePage);
    }

    protected int flush(int cachePage) {
        return this.flush0(cachePage, true, true);
    }

    protected int flush_mut(int cachePage) {
        return this.flush0(cachePage, true, true);
    }

    protected int flush0(int cachePage, boolean check_range, boolean check_dirty) {
        if (check_range) {
            this.arg_cachePage_range(cachePage);
        }
        if (check_dirty && !this.dirty(cachePage)) {
            return -1;
        }
        int persistPage = this.cache2persist(cachePage);
        if (persistPage < 0) {
            return persistPage;
        }
        this.state.persistentPages().writePage(persistPage, ((DirtyPagedDataBase)this.state.cachePages()).readPage(cachePage));
        ((DirtyPagedDataBase)this.state.cachePages()).flushPage(cachePage);
        return persistPage;
    }

    @Override
    public void flush() {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        Object dirty = this.state.cachePages();
        if (dirty == null) {
            throw new IllegalStateException("state.cachePages() is null");
        }
        ((DirtyPagedDataBase)dirty).dirtyPages((Consumer1<Integer>)((Consumer1 & Serializable)this::flush));
    }

    protected int unmap(int cachePage) {
        int persistPage;
        this.arg_cachePage_range(cachePage);
        if (this.dirty_mut(cachePage)) {
            this.flush_mut(cachePage);
        }
        if ((persistPage = this.cache2persist_mut(cachePage)) < 0) {
            return persistPage;
        }
        this.state.prst2cache_write(map -> (Integer)map.remove(persistPage));
        this.state.cache2prst_write(arr -> arr.set(cachePage, -1));
        return persistPage;
    }

    protected Tuple2<List<Integer>, List<Integer>> cleanDirtyPages() {
        Tuple2 res = this.state.cache2prst_read(arr -> {
            ArrayList<Integer> cleanPages = new ArrayList<Integer>(arr.length());
            ArrayList<Integer> dirtyPages = new ArrayList<Integer>(arr.length());
            for (int i = 0; i < arr.length(); ++i) {
                int p = arr.get(i);
                if (p < 0) {
                    cleanPages.add(i);
                    continue;
                }
                dirtyPages.add(i);
            }
            return Tuple2.of(cleanPages, dirtyPages);
        });
        return res;
    }

    protected int unmapCandidate(List<Integer> pages, boolean clean) {
        if (pages.isEmpty()) {
            return -1;
        }
        return pages.get(ThreadLocalRandom.current().nextInt(pages.size()));
    }

    protected int allocCachePage() {
        int p;
        int cachePagesCount = ((DirtyPagedDataBase)this.state.cachePages()).memoryInfo().pageCount();
        if (cachePagesCount < 1) {
            throw new IllegalStateException("cachePages pages not exists, call resizeCachePages");
        }
        int unmappedCachePage = this.state.cache2prst_read(arr -> {
            for (int i = 0; i < arr.length(); ++i) {
                int x = arr.get(i);
                if (x >= 0) continue;
                return i;
            }
            return -1;
        });
        if (unmappedCachePage >= 0) {
            return unmappedCachePage;
        }
        Tuple2<List<Integer>, List<Integer>> cleanDirtyPages = this.cleanDirtyPages();
        List cleanPages = (List)cleanDirtyPages.a();
        List dirtyPages = (List)cleanDirtyPages.b();
        if (!cleanPages.isEmpty() && (p = this.unmapCandidate(cleanPages, true)) >= 0) {
            return p;
        }
        if (dirtyPages.isEmpty()) {
            throw new IllegalStateException("all cache pages is busy, call resizeCachePages");
        }
        p = this.unmapCandidate(dirtyPages, false);
        if (p >= 0) {
            this.unmap(p);
            return p;
        }
        throw new IllegalStateException("all cache pages is busy, call resizeCachePages");
    }

    protected byte[] map(int cachePage, int persistPage) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        this.arg_cachePage_range(cachePage);
        int prst_p_cnt = this.state.persistentPages().memoryInfo().pageCount();
        int cche_p_cnt = ((DirtyPagedDataBase)this.state.cachePages()).memoryInfo().pageCount();
        if (cachePage < 0 || cachePage >= cche_p_cnt) {
            throw new IllegalArgumentException("cachePage<0 || cachePage>=cche_p_cnt; cachePage=" + cachePage + " cche_p_cnt=" + cche_p_cnt);
        }
        if (persistPage < 0 || persistPage >= prst_p_cnt) {
            throw new IllegalArgumentException("persistPage<0 || persistPage>=prst_p_cnt; persistPage=" + persistPage + " prst_p_cnt=" + prst_p_cnt);
        }
        int mapped_prst_page = this.cache2persist_mut(cachePage);
        if (mapped_prst_page >= 0) {
            this.unmap(mapped_prst_page);
        }
        byte[] buff = this.state.persistentPages().readPage(persistPage);
        ((DirtyPagedDataBase)this.state.cachePages()).writePage(cachePage, buff);
        ((DirtyPagedDataBase)this.state.cachePages()).flushPage(cachePage);
        this.state.cache2prst_write(arr -> arr.set(cachePage, persistPage));
        this.state.prst2cache_write(map -> map.put(persistPage, cachePage));
        return buff;
    }

    @Override
    public byte[] readPage(int page) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        int cidx = this.persist2cache(page);
        if (cidx >= 0) {
            return this.readPage_mapped(cidx, page);
        }
        return this.readPage_alloc(page);
    }

    protected byte[] readPage_mapped(int cidx, int page) {
        this.state.statCacheHitMiss(true);
        return ((DirtyPagedDataBase)this.state.cachePages()).readPage(cidx);
    }

    protected byte[] readPage_alloc(int page) {
        int cache_page = this.allocCachePage();
        if (cache_page < 0) {
            throw new IllegalStateException("can't allocate page in cache");
        }
        this.state.statCacheHitMiss(false);
        return this.map(cache_page, page);
    }

    @Override
    public void writePage(int page, byte[] data) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        int page_size = ((DirtyPagedDataBase)this.state.cachePages()).memoryInfo().pageSize();
        if (data.length > page_size) {
            throw new IllegalArgumentException("data.length(=" + data.length + ") > page_size(=" + page_size + ")");
        }
        int cidx = this.persist2cache(page);
        if (cidx >= 0) {
            this.writePage_mapped(cidx, page, data);
        } else {
            this.writePage_alloc(page, data);
        }
    }

    protected void writePage_mapped(int cidx, int page, byte[] data) {
        this.state.statCacheHitMiss(true);
        this.state.persistentPages().writePage(cidx, data);
    }

    protected void writePage_alloc(int page, byte[] data) {
        this.state.statCacheHitMiss(false);
        int cache_page = this.allocCachePage();
        byte[] buff = this.map(cache_page, page);
        if (buff.length > data.length) {
            System.arraycopy(data, 0, buff, 0, data.length);
            ((DirtyPagedDataBase)this.state.cachePages()).writePage(cache_page, buff);
        } else {
            ((DirtyPagedDataBase)this.state.cachePages()).writePage(cache_page, data);
        }
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of(this.state.persistentPages().memoryInfo(), this.state.persistentPages().memoryInfo());
        }
        return this.state.persistentPages().extendPages(pages);
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of(this.state.persistentPages().memoryInfo(), this.state.persistentPages().memoryInfo());
        }
        int curr_pages = this.state.persistentPages().memoryInfo().pageCount();
        int next_pages = curr_pages - pages;
        if (next_pages < 0) {
            throw new IllegalArgumentException("reduce pages to big");
        }
        this.state.cache2prst_write(arr -> {
            for (int c_page = 0; c_page < arr.length(); ++c_page) {
                int p_page = this.cache2persist_mut(c_page);
                if (p_page < next_pages) continue;
                this.unmap(c_page);
            }
        });
        return this.state.persistentPages().reducePages(pages);
    }

    public Tuple2<UsedPagesInfo, UsedPagesInfo> resizeCachePages(int pages) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        int c2p_len = this.state.cache2prst_read(IntArrayReadOnly::length);
        int diff = pages - c2p_len;
        if (diff == 0) {
            return Tuple2.of(((DirtyPagedDataBase)this.state.cachePages()).memoryInfo(), ((DirtyPagedDataBase)this.state.cachePages()).memoryInfo());
        }
        if (diff > 0) {
            Tuple2<UsedPagesInfo, UsedPagesInfo> res = ((DirtyPagedDataBase)this.state.cachePages()).resizePages(pages);
            this.state.cache2prst_replace(arr -> {
                int[] n_arr = arr.toArray();
                n_arr = Arrays.copyOf(n_arr, pages);
                for (int cache_page = c2p_len; cache_page < pages; ++cache_page) {
                    n_arr[cache_page] = -1;
                }
                return n_arr;
            });
            return res;
        }
        this.state.cache2prst_replace(arr -> {
            int[] n_arr = arr.toArray();
            for (int cache_page = 0; cache_page < n_arr.length; ++cache_page) {
                if (cache_page < pages) continue;
                this.unmap(cache_page);
            }
            n_arr = Arrays.copyOf(n_arr, pages);
            return n_arr;
        });
        return ((DirtyPagedDataBase)this.state.cachePages()).resizePages(pages);
    }
}

