/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.Flushable;
import xyz.cofe.cbuffer.page.PagedData;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public class CBuffPagedData
implements PagedData,
Flushable,
ResizablePages {
    protected final ContentBuffer cbuff;
    protected final int pageSize;
    protected long maxSize = -1L;
    protected boolean resizeable = false;

    public CBuffPagedData(ContentBuffer cbuff, int pageSize, boolean resizeable, long maxSize) {
        if (cbuff == null) {
            throw new IllegalArgumentException("cbuff==null");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (maxSize > 1L && maxSize % (long)pageSize > 0L) {
            throw new IllegalArgumentException("maxSize not aligned by pageSize");
        }
        this.pageSize = pageSize;
        this.cbuff = cbuff;
        this.maxSize = maxSize;
        this.resizeable = resizeable;
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        long c;
        long s = this.cbuff.getSize();
        if (s <= 0L) {
            return UsedPagesInfo.of(0, 0, 0);
        }
        long pc = s / (long)this.pageSize;
        if (pc > Integer.MAX_VALUE) {
            throw new IllegalStateException("pageCount more than Integer.MAX_VALUE");
        }
        long pc_1 = s % (long)this.pageSize;
        long l = c = pc_1 > 0L ? pc + 1L : pc;
        if (c > Integer.MAX_VALUE) {
            throw new IllegalStateException("pageCount more than Integer.MAX_VALUE");
        }
        return UsedPagesInfo.of(this.pageSize, (int)c, (int)pc_1);
    }

    @Override
    public byte[] readPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        long total = this.cbuff.getSize();
        if (total <= 0L) {
            return new byte[0];
        }
        int pages = this.memoryInfo().pageCount();
        if (page >= pages) {
            return new byte[0];
        }
        long off = (long)page * (long)this.pageSize;
        long avail = total - off;
        if (avail <= 0L) {
            return new byte[0];
        }
        int avail_i = avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        int read = Math.min(avail_i, this.pageSize);
        return this.cbuff.get(off, read);
    }

    @Override
    public void writePage(int page, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (data.length < 1) {
            return;
        }
        if (data.length > this.pageSize) {
            throw new IllegalArgumentException("data.length(=" + data.length + ") > pageSize(=" + this.pageSize + ")");
        }
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        long total = this.cbuff.getSize();
        if (total <= 0L) {
            throw new IllegalStateException("pages not exists");
        }
        int pages = this.memoryInfo().pageCount();
        if (page >= pages) {
            if (!this.resizeable) {
                throw new IllegalStateException("can't resize to " + (page + 1) + " pages; not resizeable");
            }
            long targetSize = (long)pages * (long)this.pageSize + (long)data.length;
            if (targetSize > this.maxSize && this.maxSize > 1L) {
                throw new IllegalStateException("can't resize to " + (page + 1) + " pages; limit by maxSize(=" + this.maxSize + ")");
            }
            long currSize = this.cbuff.getSize();
            if (currSize < targetSize) {
                this.cbuff.setSize(targetSize);
            }
        }
        long off = (long)pages * (long)this.pageSize;
        if (data.length < this.pageSize) {
            byte[] buff = this.cbuff.get(off, this.pageSize);
            System.arraycopy(data, 0, buff, 0, data.length);
            this.cbuff.set(off, buff, 0, buff.length);
        } else {
            this.cbuff.set(off, data, 0, data.length);
        }
    }

    @Override
    public void flush() {
        this.cbuff.flush();
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of((Object)this.memoryInfo().clone(), (Object)this.memoryInfo());
        }
        if (!this.resizeable) {
            throw new IllegalStateException("can't resize, not resizeable");
        }
        UsedPagesInfo pi = this.memoryInfo();
        long targetPages = (long)pi.pageCount() + (long)this.pageSize;
        if (targetPages > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can't extend to " + targetPages + " pages; is more than Integer.MAX_VALUE");
        }
        long targetSize = targetPages * (long)pi.pageSize();
        if (targetSize > this.maxSize && this.maxSize > 0L) {
            throw new IllegalArgumentException("can't extend to " + targetSize + " bytes; is more than maxSize(=" + this.maxSize + ")");
        }
        pi = pi.clone();
        this.cbuff.setSize(targetSize);
        return Tuple2.of((Object)pi, (Object)this.memoryInfo());
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of((Object)this.memoryInfo().clone(), (Object)this.memoryInfo());
        }
        if (!this.resizeable) {
            throw new IllegalStateException("can't resize, not resizeable");
        }
        UsedPagesInfo pi = this.memoryInfo();
        long targetPages = (long)pi.pageCount() + (long)this.pageSize;
        if (targetPages < 0L) {
            throw new IllegalArgumentException("can't reduce to " + targetPages + " pages; is less than 0");
        }
        long targetSize = targetPages * (long)pi.pageSize();
        pi = pi.clone();
        this.cbuff.setSize(targetSize);
        return Tuple2.of((Object)pi, (Object)this.memoryInfo());
    }
}

