/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import xyz.cofe.cbuffer.ContentBuffer;

public class SyncContentBuffer
implements ContentBuffer {
    protected volatile ContentBuffer buffer = null;
    protected volatile boolean copyLock = false;
    protected final Object sync;

    public final Object getSyncObject() {
        return this.sync;
    }

    public SyncContentBuffer(ContentBuffer buffer, Object sync, boolean copyLock) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer==null");
        }
        this.sync = sync != null ? sync : this;
        this.buffer = buffer;
        this.copyLock = copyLock;
    }

    public SyncContentBuffer(ContentBuffer buffer, Object sync) {
        this(buffer, sync, false);
    }

    public SyncContentBuffer(ContentBuffer buffer) {
        this(buffer, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        if (this.buffer == null) {
            return 0L;
        }
        Object object = this.sync;
        synchronized (object) {
            return this.buffer.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(long size) {
        if (this.buffer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.buffer.setSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (this.buffer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.buffer.set(offset, data, dataOffset, dataLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long offset, int dataLen) {
        if (this.buffer == null) {
            return new byte[0];
        }
        Object object = this.sync;
        synchronized (object) {
            return this.buffer.get(offset, dataLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.buffer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.buffer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.buffer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.buffer.close();
            this.buffer = null;
        }
    }
}

