/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.util.Arrays;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.Flushable;
import xyz.cofe.cbuffer.page.PageLock;
import xyz.cofe.cbuffer.page.ResizablePages;

public class PagesBuffer
implements ContentBuffer {
    protected final ResizablePages pages;

    public PagesBuffer(ResizablePages pages) {
        if (pages == null) {
            throw new IllegalArgumentException("pages==null");
        }
        this.pages = pages;
    }

    @Override
    public long getSize() {
        Object upi = this.pages.memoryInfo();
        int ps = upi.pageSize();
        if (ps <= 0) {
            return 0L;
        }
        int pc = upi.pageCount();
        if (pc <= 0) {
            return 0L;
        }
        int lps = upi.lastPageSize();
        if (lps == ps) {
            return (long)ps * (long)pc;
        }
        if (lps < ps) {
            long s = (long)pc * (long)ps;
            return s -= (long)(ps - lps);
        }
        return (long)pc * (long)ps;
    }

    @Override
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size<0");
        }
        if (size == 0L) {
            this.pages.resizePages(0);
        } else {
            Object upi = this.pages.memoryInfo();
            int ps = upi.pageSize();
            if (ps <= 0) {
                throw new IllegalStateException("page size <= 0");
            }
            int pc = upi.pageCount();
            int lps = upi.lastPageSize();
            long n_pc_long = size / (long)ps;
            if (n_pc_long > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("can't allocate pages over Integer.MAX_VALUE");
            }
            long n_ext = size % (long)pc;
            if (n_ext > 0L) {
                ++n_pc_long;
            }
            if (n_pc_long > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("can't allocate pages over Integer.MAX_VALUE");
            }
            int n_pc = (int)n_pc_long;
            if (n_pc != pc) {
                this.pages.resizePages(n_pc);
            }
        }
    }

    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset<0");
        }
        if (data.length < dataOffset + dataLen) {
            throw new IllegalArgumentException("data.length(=" + data.length + ") < (dataOffset(=" + dataOffset + ")+dataLen(=" + dataLen + "))");
        }
        if (dataLen == 0) {
            return;
        }
        int page_size = this.pages.memoryInfo().pageSize();
        if (page_size < 1) {
            throw new IllegalStateException("pageSize(=" + page_size + ") to small, must be 1 or greater");
        }
        long page_from = offset / (long)page_size;
        if (page_from > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_from + ") > Integer.MAX_VALUE");
        }
        long page_to = (offset + (long)dataLen) / (long)page_size + 1L;
        if (page_to > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_to + ") > Integer.MAX_VALUE");
        }
        Runnable write = () -> {
            int write_size;
            int page = (int)page_from;
            int page_off = (int)(offset % (long)page_size);
            byte[] page_buff = new byte[page_size];
            for (int writed = 0; writed < dataLen; writed += write_size) {
                int page_av = page_size - page_off;
                int avail = dataLen - writed;
                write_size = Math.min(avail, page_av);
                if (page_off > 0 || write_size != page_size) {
                    byte[] page_data = this.pages.readPage(page);
                    if (page_data.length < page_size) {
                        page_data = Arrays.copyOf(page_data, page_size);
                    }
                    System.arraycopy(data, writed + dataOffset, page_data, page_off, write_size);
                    this.pages.writePage(page, page_data);
                } else {
                    System.arraycopy(data, writed + dataOffset, page_buff, 0, page_size);
                    this.pages.writePage(page, page_buff);
                }
                page_off = 0;
                ++page;
            }
        };
        if (this.pages instanceof PageLock) {
            ((PageLock)((Object)this.pages)).writePageLock((int)page_from, (int)page_to, write);
        } else {
            write.run();
        }
    }

    @Override
    public byte[] get(long offset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (dataLen == 0) {
            return new byte[0];
        }
        long total_bytes_count = this.getSize();
        if (offset >= total_bytes_count) {
            return new byte[0];
        }
        int page_size = this.pages.memoryInfo().pageSize();
        if (page_size < 1) {
            throw new IllegalStateException("pageSize(=" + page_size + ") to small, must be 1 or greater");
        }
        long page_from = offset / (long)page_size;
        if (page_from > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_from + ") > Integer.MAX_VALUE");
        }
        long page_to = (offset + (long)dataLen) / (long)page_size + 1L;
        if (page_to > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_to + ") > Integer.MAX_VALUE");
        }
        int[] bytesReaded = new int[]{0};
        byte[] buff = new byte[dataLen];
        Runnable read = () -> {
            int readed = 0;
            int page = (int)page_from;
            int page_off = (int)(offset % (long)page_size);
            while (readed < dataLen) {
                int avail = page_size - page_off;
                int need = dataLen - readed;
                int read_size = Math.min(avail, need);
                byte[] bytes = this.pages.readPage(page);
                int valid_data_size = bytes.length - page_off;
                if (valid_data_size < read_size) {
                    if (bytes.length <= 0 || page_off >= bytes.length) break;
                    System.arraycopy(bytes, page_off, buff, readed, bytes.length - page_off);
                    readed += bytes.length - page_off;
                    break;
                }
                System.arraycopy(bytes, page_off, buff, readed, read_size);
                readed += read_size;
                ++page;
                page_off = 0;
            }
            bytesReaded[0] = readed;
        };
        if (this.pages instanceof PageLock) {
            ((PageLock)((Object)this.pages)).readPageLock((int)page_from, (int)page_to, read);
        } else {
            read.run();
        }
        byte[] res_buff = buff;
        if (bytesReaded[0] < res_buff.length) {
            res_buff = Arrays.copyOf(res_buff, bytesReaded[0]);
        }
        return res_buff;
    }

    @Override
    public void clear() {
        this.setSize(0L);
    }

    @Override
    public void flush() {
        if (this.pages instanceof Flushable) {
            ((Flushable)((Object)this.pages)).flush();
        }
    }

    @Override
    public void close() {
        if (this.pages instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.pages)).close();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

