/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBufferInputStream;
import xyz.cofe.cbuffer.ContentBufferOutputStream;
import xyz.cofe.cbuffer.RAFBuffer;
import xyz.cofe.io.fn.IOFun;

public class FileLockBuffer
extends RAFBuffer {
    private static final Logger logger = Logger.getLogger(FileLockBuffer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected WeakReference<FileLockBuffer> original;
    protected FileLock fileLock;
    protected final Set<FileLock> fileLocks = new LinkedHashSet<FileLock>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public FileLockBuffer() {
    }

    public FileLockBuffer(Lock lock) {
        super(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLockBuffer(FileLockBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        try {
            src.lock.lock();
            if (src.cloneRafContent) {
                RandomAccessFile traf;
                this.raf = traf = src.createTempRAF();
                RandomAccessFile rafSrc = src.raf;
                RandomAccessFile rafDest = traf;
                if (rafSrc != null && rafDest != null) {
                    ContentBufferInputStream cin = null;
                    cin = new ContentBufferInputStream(src);
                    ContentBufferOutputStream cout = null;
                    cout = new ContentBufferOutputStream(this);
                    try {
                        IOFun.copy((InputStream)cin, (OutputStream)cout);
                    }
                    catch (IOException err) {
                        throw new IOError(err);
                    }
                    try {
                        cout.close();
                    }
                    catch (IOException err) {
                        throw new IOError(err);
                    }
                    try {
                        cin.close();
                    }
                    catch (IOException err) {
                        throw new IOError(err);
                    }
                }
                this.raf = src.raf;
                this.original = null;
            }
            this.throwNotSetRaf = src.throwNotSetRaf;
            this.flushOnClose = src.flushOnClose;
            this.cloneRafContent = src.cloneRafContent;
            this.closeRaf = src.closeRaf;
            this.deleteTempOnExit = src.deleteTempOnExit;
            this.releaseRaf = src.releaseRaf;
            if (src.cloneRafContent) {
                this.fileLock = null;
                this.original = null;
            } else {
                this.fileLock = src.fileLock;
                this.original = new WeakReference<FileLockBuffer>(src);
            }
        }
        finally {
            src.lock.unlock();
        }
    }

    @Override
    public FileLockBuffer clone() {
        return new FileLockBuffer(this);
    }

    @Override
    public void setRaf(RandomAccessFile raf) {
        try {
            this.lock.lock();
            super.setRaf(raf);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFileLock() {
        try {
            this.lock.lock();
            if (this.fileLock != null && this.fileLock.isValid()) {
                boolean bl = true;
                return bl;
            }
            for (FileLock fl : this.fileLocks) {
                if (fl == null) continue;
                if (!fl.isValid()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FileLock getFileLock() {
        try {
            this.lock.lock();
            FileLock fileLock = this.fileLock;
            return fileLock;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<FileLock> getFileLocks() {
        try {
            this.lock.lock();
            LinkedHashSet<FileLock> fset = new LinkedHashSet<FileLock>();
            fset.addAll(this.fileLocks);
            LinkedHashSet<FileLock> linkedHashSet = fset;
            return linkedHashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock fileLock() {
        try {
            Object flb;
            this.lock.lock();
            if (this.raf == null) {
                if (this.throwNotSetRaf) {
                    throw new IllegalArgumentException("property raf not set");
                }
                FileLock fileLock = null;
                return fileLock;
            }
            if (this.original != null) {
                flb = (FileLockBuffer)this.original.get();
                if (flb != null) {
                    FileLock fl = ((FileLockBuffer)flb).fileLock();
                    if (fl != null) {
                        this.fileLocks.add(fl);
                    }
                    FileLock fileLock = fl;
                    return fileLock;
                }
                this.original = null;
            }
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLocks.add(this.fileLock);
                flb = this.fileLock;
                return flb;
            }
            try {
                this.fileLock = this.raf.getChannel().lock();
                this.fileLocks.add(this.fileLock);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
            FileLock fileLock = this.fileLock;
            return fileLock;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock fileUnlock() {
        try {
            this.lock.lock();
            FileLock res = null;
            if (this.original != null) {
                FileLockBuffer flb = (FileLockBuffer)this.original.get();
                if (flb != null) {
                    FileLock f = flb.fileUnlock();
                    if (f != null && !f.isValid()) {
                        this.fileLocks.remove(f);
                        res = f;
                    }
                } else {
                    this.original = null;
                }
            }
            if (this.fileLock != null && this.fileLock.isValid()) {
                try {
                    this.fileLock.release();
                    this.fileLocks.remove(this.fileLock);
                    res = this.fileLock;
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
            for (FileLock fl : this.fileLocks) {
                try {
                    if (fl == null || !fl.isValid()) continue;
                    fl.release();
                    res = fl;
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
            this.fileLocks.clear();
            Iterator<FileLock> iterator = res;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.fileUnlock();
        super.close();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

