/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Arrays;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.FastDataSize;
import xyz.cofe.cbuffer.page.GetPageSize;
import xyz.cofe.cbuffer.page.PageBuffers;

public interface PageFastRead
extends GetPageSize,
PageBuffers,
FastDataSize {
    default public byte[] fastData(int pageIndex) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex<0");
        }
        int pageCnt = this.fastPageCount();
        if (pageIndex >= pageCnt) {
            throw new IllegalArgumentException("pageIndex >= fastPageCount(=" + pageCnt + ")");
        }
        ContentBuffer buff = this.getFastBuffer();
        if (buff == null) {
            throw new IllegalStateException("fast buffer not available");
        }
        int pageSize = this.getPageSize();
        if (pageSize < 1) {
            return null;
        }
        int dataSize = this.fastDataSize(pageIndex);
        if (dataSize < 0) {
            return null;
        }
        if (dataSize == 0) {
            return new byte[0];
        }
        byte[] data = buff.get(pageSize * pageIndex, dataSize);
        if (data == null) {
            return null;
        }
        if (data.length <= dataSize) {
            return data;
        }
        return Arrays.copyOf(data, dataSize);
    }

    public int fastPageCount();
}

