/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page.cbuff;

import java.io.ByteArrayOutputStream;
import xyz.cofe.cbuffer.page.GetPageSize;
import xyz.cofe.cbuffer.page.cbuff.RWPageData;
import xyz.cofe.cbuffer.page.cbuff.ToPageAddress;

public interface PageGetSet
extends RWPageData,
ToPageAddress,
GetPageSize {
    default public byte[] get(long offset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int pageSize = this.getPageSize();
        byte[] buff = new byte[pageSize];
        long off = offset;
        while (bytes.size() < dataLen) {
            int[] paddr = this.toPageAddress(off);
            if (paddr == null) {
                return bytes.toByteArray();
            }
            int chunckSize = Math.max(buff.length, dataLen - bytes.size());
            int readed = this.readPageData(buff, 0, paddr, chunckSize);
            if (readed > 0) {
                bytes.write(buff, 0, readed);
            } else if (readed <= 0) {
                return bytes.toByteArray();
            }
            off += (long)readed;
        }
        return bytes.toByteArray();
    }

    default public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (dataLen == 0) {
            return;
        }
        int dataEndOffset = dataOffset + dataLen;
        if (dataEndOffset > data.length) {
            throw new IllegalArgumentException("dataOffset out of bounds");
        }
        int pageSize = this.getPageSize();
        long off = offset;
        int[] paddr = this.toPageAddress(off);
    }
}

