/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.GetPageSize;
import xyz.cofe.cbuffer.page.PageBuffers;

public interface PageSlowRead
extends GetPageSize,
PageBuffers {
    default public byte[] slowData(int pageIndex) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex<0");
        }
        int pageSize = this.getPageSize();
        if (pageSize < 1) {
            return null;
        }
        ContentBuffer buff = this.getSlowBuffer();
        if (buff == null) {
            throw new IllegalStateException("slow buffer not available");
        }
        return buff.get((long)pageSize * (long)pageIndex, pageSize);
    }

    default public int getMaxSlowPageIndex() {
        ContentBuffer buff = this.getSlowBuffer();
        if (buff == null) {
            throw new IllegalStateException("slow buffer not available");
        }
        int pageSize = this.getPageSize();
        if (pageSize < 1) {
            throw new IllegalStateException("pageSize to small");
        }
        long pi = buff.getSize() / (long)pageSize;
        if (pi > Integer.MAX_VALUE) {
            throw new IllegalStateException("max page (=" + pi + ") out of Integer range (..." + Integer.MAX_VALUE + ")");
        }
        return (int)pi;
    }
}

