/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.FastDataSize;
import xyz.cofe.cbuffer.page.PageFastDirty;
import xyz.cofe.cbuffer.page.PageFastRead;

public interface PageFastWrite
extends PageFastRead,
PageFastDirty,
FastDataSize {
    default public void fastData(int pageIndex, byte[] bytes) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex<0");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        int pageCnt = this.fastPageCount();
        if (pageIndex >= pageCnt) {
            throw new IllegalArgumentException("pageIndex >= fastPageCount(=" + pageCnt + ")");
        }
        ContentBuffer buff = this.getFastBuffer();
        if (buff == null) {
            throw new IllegalStateException("fast buffer not available");
        }
        int pageSize = this.getPageSize();
        if (pageSize < 1) {
            throw new IllegalStateException("pageSize to small");
        }
        if (bytes.length > pageSize) {
            throw new IllegalArgumentException("bytes.length > pageSize(=" + pageSize + ")");
        }
        buff.set(pageIndex * pageSize, bytes, 0, bytes.length);
        this.dirty(pageIndex, true);
        this.fastDataSize(pageIndex, bytes.length);
    }
}

