/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import xyz.cofe.ecolls.ListenersHelper;

public class PageEvent<T>
implements Consumer<T> {
    public final ExtListenersHelper<Consumer<? super T>, ? super T> helper = new ExtListenersHelper<Consumer, Object>((ls, ev) -> {
        if (ls != null) {
            ls.accept(ev);
        }
    });

    public int getListenersCount() {
        return this.helper.getListenersCount();
    }

    public AutoCloseable listen(Consumer<? super T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        return this.helper.addListener(listener);
    }

    public <A extends T> void notify(A ev) {
        this.helper.fireEvent(ev);
    }

    public <A extends T> void send(Supplier<A> ev) {
        A a;
        if (ev == null) {
            throw new IllegalArgumentException("ev==null");
        }
        if (this.getListenersCount() > 0 && (a = ev.get()) != null) {
            this.helper.fireEvent(a);
        }
    }

    @Override
    public void accept(T ev) {
        if (ev != null) {
            this.helper.fireEvent(ev);
        }
    }

    public static class ExtListenersHelper<ListenerType, EventType>
    extends ListenersHelper<ListenerType, EventType> {
        public ExtListenersHelper(BiConsumer<ListenerType, EventType> callListFunc) {
            super(callListFunc);
        }

        public ExtListenersHelper(BiConsumer<ListenerType, EventType> callListFunc, ReadWriteLock rwLocks) {
            super(callListFunc, rwLocks);
        }

        public int getListenersCount() {
            return this.listeners.size() + this.weakListeners.size();
        }
    }
}

