/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.page.PageFastRead;
import xyz.cofe.cbuffer.page.PageFastWrite;
import xyz.cofe.cbuffer.page.PageLoad;
import xyz.cofe.cbuffer.page.PageMap;
import xyz.cofe.cbuffer.page.PageSlowRead;

public interface PageData
extends PageMap,
PageFastRead,
PageFastWrite,
PageSlowRead,
PageLoad {
    default public byte[] data(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        int fastIdx = this.slowToFast(page);
        if (fastIdx >= 0) {
            return this.fastData(fastIdx);
        }
        int maxSlowPI = this.getMaxSlowPageIndex();
        if (page > maxSlowPI) {
            return new byte[0];
        }
        fastIdx = this.map(page);
        if (fastIdx < 0) {
            throw new IllegalStateException("can't load page=" + page);
        }
        return this.fastData(fastIdx);
    }

    default public void data(int page, byte[] bytes) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        if (bytes.length == 0) {
            return;
        }
        int fastIdx = this.slowToFast(page);
        if (fastIdx >= 0) {
            this.fastData(fastIdx, bytes);
            return;
        }
        fastIdx = this.map(page);
        if (fastIdx < 0) {
            throw new IllegalStateException("can't load page=" + page);
        }
        this.fastData(fastIdx, bytes);
    }
}

