/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;

public class WrapperContentBuffer<T extends ContentBuffer>
implements ContentBuffer {
    private static final Logger logger = Logger.getLogger(WrapperContentBuffer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected T buffer;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public WrapperContentBuffer(T cbuffer) {
        if (cbuffer == null) {
            throw new IllegalArgumentException("cbuffer==null");
        }
        this.buffer = cbuffer;
        this.lock = new ReentrantLock();
    }

    public WrapperContentBuffer(T cbuffer, Lock lock) {
        if (cbuffer == null) {
            throw new IllegalArgumentException("cbuffer==null");
        }
        this.buffer = cbuffer;
        this.lock = lock == null ? new ReentrantLock() : lock;
    }

    public T getWrappedBuffer() {
        try {
            this.lock.lock();
            T t = this.buffer;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setWrappedBuffer(T cbuffer) {
        try {
            this.lock.lock();
            if (this.buffer == null) {
                throw new IllegalArgumentException("buffer==null");
            }
            this.buffer = cbuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getSize() {
        try {
            this.lock.lock();
            long l = this.buffer.getSize();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setSize(long size) {
        try {
            this.lock.lock();
            this.buffer.setSize(size);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        try {
            this.lock.lock();
            this.buffer.set(offset, data, dataOffset, dataLen);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long offset, int dataLen) {
        try {
            this.lock.lock();
            byte[] byArray = this.buffer.get(offset, dataLen);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.buffer.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.lock.lock();
            this.buffer.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            this.buffer.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

