/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xyz.cofe.cbuffer.ContentBuffer;

public class ContentBufferOutputStream
extends OutputStream {
    protected Lock lock = null;
    protected ContentBuffer contentBuffer = null;
    protected long beginIndex = -1L;
    protected long endIndexExclusive = -1L;
    protected long pointer = 0L;

    public ContentBufferOutputStream(ContentBuffer buffer, long beginIndex, long endIndexExclusive, Lock lock) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer == null");
        }
        if (beginIndex < 0L) {
            beginIndex = 0L;
        }
        this.contentBuffer = buffer;
        this.beginIndex = beginIndex;
        this.endIndexExclusive = endIndexExclusive;
        this.pointer = beginIndex;
        this.lock = lock;
    }

    public ContentBufferOutputStream(ContentBuffer buffer, long beginIndex, long endIndexExclusive) {
        this(buffer, beginIndex, endIndexExclusive, new ReentrantLock());
    }

    public ContentBufferOutputStream(ContentBuffer buffer, long beginIndex) {
        this(buffer, beginIndex, -1L);
    }

    public ContentBufferOutputStream(ContentBuffer buffer) {
        this(buffer, 0L, -1L);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                this.write0(b);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.write0(b);
        }
    }

    private void write0(int b) throws IOException {
        byte[] buff = new byte[]{(byte)(b + -128)};
        if (this.contentBuffer == null) {
            return;
        }
        if (this.endIndexExclusive >= 0L && this.pointer >= this.endIndexExclusive) {
            return;
        }
        this.contentBuffer.set(this.pointer, buff, 0, 1);
        ++this.pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                this.write0(b, off, len);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.write0(b, off, len);
        }
    }

    private void write0(byte[] b, int off, int len) throws IOException {
        if (this.contentBuffer == null) {
            return;
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (len == 0) {
            return;
        }
        if (off >= b.length) {
            throw new IllegalArgumentException("off >= b.length");
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException("off + len > b.length");
        }
        if (this.endIndexExclusive >= 0L && this.pointer >= this.endIndexExclusive) {
            return;
        }
        this.contentBuffer.set(this.pointer, b, off, len);
        this.pointer += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        if (this.contentBuffer == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                this.close0();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.close0();
        }
    }

    private void close0() throws IOException {
        if (this.contentBuffer != null) {
            this.contentBuffer.flush();
            this.contentBuffer = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                this.flush0();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.flush0();
        }
    }

    private void flush0() throws IOException {
        if (this.contentBuffer != null) {
            this.contentBuffer.flush();
        }
    }
}

