/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import xyz.cofe.cbuffer.page.PageData;
import xyz.cofe.cbuffer.page.PageDataAbstract;
import xyz.cofe.cbuffer.page.PageDataReaded;
import xyz.cofe.cbuffer.page.PageDataWrited;
import xyz.cofe.cbuffer.page.PageEvent;
import xyz.cofe.cbuffer.page.PageMapEntry;
import xyz.cofe.cbuffer.page.PageSlowWrite;
import xyz.cofe.collection.IndexSet;
import xyz.cofe.collection.IndexSetBasic;
import xyz.cofe.fn.Pair;

public class PageDataImpl
extends PageDataAbstract
implements PageData,
PageSlowWrite {
    public final PageEvent<Pair<Integer, byte[]>> onFastDataWrited = new PageEvent();
    public final PageEvent<Pair<Integer, Integer>> onFastDataSize = new PageEvent();
    private final Map<Integer, Integer> fastDataSize = new HashMap<Integer, Integer>();
    public final Map<Integer, Boolean> dirtyFastPages = new HashMap<Integer, Boolean>();
    public final PageEvent<Pair<Integer, Boolean>> onDirty = new PageEvent();
    protected final Map<Integer, Integer> fast2slow = new HashMap<Integer, Integer>();
    protected final Map<Integer, Integer> slow2fast = new HashMap<Integer, Integer>();
    protected final IndexSet<Integer> freepages = new IndexSetBasic();
    protected final IndexSet<Integer> usedpages = new IndexSetBasic();
    private volatile int maxFastPageCount = 16;
    public final PageEvent<Integer> onAllocFreePage = new PageEvent();
    public final PageEvent<Integer> onAllocNewPage = new PageEvent();
    public final PageEvent<Integer> onAllocExistsPage = new PageEvent();
    public final PageEvent<Integer> onAlloc = new PageEvent();
    public final PageEvent<PageMapEntry> onUnmapped;
    public final PageEvent<PageMapEntry> onMapped;
    public final PageEvent<Integer> onSavedFastPage;
    public final PageEvent<PageDataReaded> onDataRead;
    public final PageEvent<PageDataWrited> onDataWrited;

    public PageDataImpl() {
        this.onAlloc.listen(this.onAllocExistsPage);
        this.onAlloc.listen(this.onAllocFreePage);
        this.onAlloc.listen(this.onAllocNewPage);
        this.onUnmapped = new PageEvent();
        this.onMapped = new PageEvent();
        this.onSavedFastPage = new PageEvent();
        this.onDataRead = new PageEvent();
        this.onDataWrited = new PageEvent();
    }

    @Override
    public void fastData(int fastPageIndex, byte[] bytes) {
        PageData.super.fastData(fastPageIndex, bytes);
        this.onFastDataWrited.notify(Pair.of((Object)fastPageIndex, (Object)bytes));
    }

    @Override
    public void fastDataSize(int fastPageIndex, int dataSize) {
        if (fastPageIndex < 0) {
            throw new IllegalArgumentException("fastPageIndex<0");
        }
        this.fastDataSize.put(fastPageIndex, dataSize);
        this.onFastDataSize.notify(Pair.of((Object)fastPageIndex, (Object)dataSize));
    }

    @Override
    public int fastDataSize(int fastPageIndex) {
        if (fastPageIndex < 0) {
            throw new IllegalArgumentException("fastPageIndex<0");
        }
        return this.fastDataSize.getOrDefault(fastPageIndex, this.getPageSize());
    }

    @Override
    public boolean dirty(int fastPageIndex) {
        return this.dirtyFastPages.getOrDefault(fastPageIndex, false);
    }

    @Override
    public void dirty(int fastPageIndex, boolean dirty) {
        this.dirtyFastPages.put(fastPageIndex, dirty);
        this.onDirty.notify(Pair.of((Object)fastPageIndex, (Object)dirty));
    }

    public int getDirtyPageCount() {
        return this.getDirtyPages().size();
    }

    public IndexSet<Integer> getDirtyPages() {
        IndexSetBasic pages = new IndexSetBasic();
        this.dirtyFastPages.forEach((arg_0, arg_1) -> PageDataImpl.lambda$getDirtyPages$0((IndexSet)pages, arg_0, arg_1));
        return pages;
    }

    @Override
    public int fastToSlow(int fastPageIndex) {
        return this.fast2slow.getOrDefault(fastPageIndex, -1);
    }

    @Override
    public int slowToFast(int slowPageIndex) {
        return this.slow2fast.getOrDefault(slowPageIndex, -1);
    }

    @Override
    public int fastPageCount() {
        return this.fast2slow.size();
    }

    public int getMaxFastPageCount() {
        return this.maxFastPageCount;
    }

    public void setMaxFastPageCount(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("max < 1");
        }
        this.maxFastPageCount = max;
    }

    private int getMaxFastPageIndex() {
        return this.fast2slow.keySet().stream().max((a, b) -> a - b).orElse(-1);
    }

    protected int allocatePage() {
        if (this.freepages.size() > 0) {
            Integer p = (Integer)this.freepages.removeByIndex(0);
            this.onAllocFreePage.notify(p);
            return p;
        }
        int maxFastPgCnt = this.getMaxFastPageCount();
        int unallocated = maxFastPgCnt - this.fastPageCount();
        if (unallocated > 0) {
            int maxPi = this.getMaxFastPageIndex();
            int p = maxPi >= 0 ? maxPi + 1 : 0;
            this.onAllocNewPage.notify(p);
            return p;
        }
        int used = this.usedpages.size();
        if (used > 0) {
            int rndint = Math.abs(ThreadLocalRandom.current().nextInt());
            int trgt = rndint % used;
            this.unmap(trgt);
            this.onAllocExistsPage.notify(trgt);
            return trgt;
        }
        if (maxFastPgCnt > 0) {
            this.onAllocNewPage.notify(0);
            return 0;
        }
        return -1;
    }

    @Override
    public int map(int slowPageIndex) {
        if (slowPageIndex < 0) {
            throw new IllegalArgumentException("slowPageIndex<0");
        }
        int trgt = this.allocatePage();
        if (trgt < 0) {
            throw new IllegalStateException("can't allocate page");
        }
        this.usedpages.add((Comparable)Integer.valueOf(trgt));
        this.freepages.remove((Comparable)Integer.valueOf(trgt));
        this.fast2slow.put(trgt, slowPageIndex);
        this.slow2fast.put(slowPageIndex, trgt);
        byte[] data = this.slowData(slowPageIndex);
        this.fastData(trgt, data);
        this.dirty(trgt, false);
        this.onMapped.notify(PageMapEntry.of(trgt, slowPageIndex));
        return trgt;
    }

    public void unmap(int fastPageIndex) {
        if (this.dirty(fastPageIndex)) {
            this.saveFastPage(fastPageIndex);
        }
        int slowPage = this.fastToSlow(fastPageIndex);
        this.slow2fast.remove(slowPage, fastPageIndex);
        this.fast2slow.remove(fastPageIndex, slowPage);
        this.freepages.add((Comparable)Integer.valueOf(fastPageIndex));
        this.usedpages.remove((Comparable)Integer.valueOf(slowPage));
        this.onUnmapped.notify(PageMapEntry.of(fastPageIndex, slowPage));
    }

    public void saveFastPage(int fastPageIndex) {
        int slowPage = this.fastToSlow(fastPageIndex);
        if (slowPage >= 0) {
            byte[] data = this.fastData(fastPageIndex);
            this.slowData(slowPage, data);
            this.dirty(fastPageIndex, false);
            this.onSavedFastPage.notify(fastPageIndex);
        }
    }

    @Override
    public byte[] data(int page) {
        byte[] bytes = PageData.super.data(page);
        this.onDataRead.send(() -> PageDataReaded.of(page, bytes));
        return bytes;
    }

    @Override
    public void data(int page, byte[] bytes) {
        PageData.super.data(page, bytes);
        this.onDataWrited.send(() -> PageDataWrited.of(page, bytes));
    }

    private static /* synthetic */ void lambda$getDirtyPages$0(IndexSet pages, Integer page, Boolean dirty) {
        if (dirty.booleanValue()) {
            pages.add((Comparable)page);
        }
    }
}

