/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.capybara.clamav.ClamavException;
import xyz.capybara.clamav.CommunicationException;
import xyz.capybara.clamav.UnknownCommandException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u001d*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0005H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lxyz/capybara/clamav/commands/Command;", "T", "", "()V", "commandString", "", "getCommandString", "()Ljava/lang/String;", "format", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "getFormat", "()Lxyz/capybara/clamav/commands/Command$CommandFormat;", "rawCommand", "Ljava/nio/ByteBuffer;", "getRawCommand", "()Ljava/nio/ByteBuffer;", "parseResponse", "responseString", "(Ljava/lang/String;)Ljava/lang/Object;", "readResponse", "socketChannel", "Ljava/nio/channels/SocketChannel;", "(Ljava/nio/channels/SocketChannel;)Ljava/lang/Object;", "removeResponseTerminator", "send", "server", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;)Ljava/lang/Object;", "CommandFormat", "Companion", "clamav-client"})
public abstract class Command<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getCommandString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T send(@NotNull InetSocketAddress server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            Closeable closeable = SocketChannel.open(server);
            Throwable throwable = null;
            try {
                SocketChannel it = (SocketChannel)closeable;
                boolean bl = false;
                it.write(this.getRawCommand());
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                T t = this.readResponse(it);
                return t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @NotNull
    protected abstract CommandFormat getFormat();

    @NotNull
    protected ByteBuffer getRawCommand() {
        String string = this.getFormat().getPrefix() + this.getCommandString() + this.getFormat().getTerminator();
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(\"${format.prefix}$c\u2026andardCharsets.US_ASCII))");
        return byteBuffer;
    }

    protected final T readResponse(@NotNull SocketChannel socketChannel) throws IOException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)socketChannel, (String)"socketChannel");
        StringBuilder responseStringBuilder = new StringBuilder();
        ByteBuffer rawResponsePart = ByteBuffer.allocate(32);
        int read = socketChannel.read(rawResponsePart);
        while (read > -1) {
            object = rawResponsePart.array();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rawResponsePart.array()");
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
            String rawResponsePartString = new String((byte[])object, charset);
            object = rawResponsePartString;
            int n = 0;
            String string = ((String)object).substring(n, read);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            rawResponsePartString = string;
            responseStringBuilder.append(rawResponsePartString);
            rawResponsePart = ByteBuffer.allocate(32);
            read = socketChannel.read(rawResponsePart);
        }
        object = responseStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"responseStringBuilder.toString()");
        String responseString = this.removeResponseTerminator((String)object);
        if (Intrinsics.areEqual((Object)responseString, (Object)"UNKNOWN COMMAND")) {
            throw new UnknownCommandException(this.getCommandString());
        }
        Companion.getLogger().debug((Function0)new Function0<Object>(this, responseString){
            final /* synthetic */ Command<T> this$0;
            final /* synthetic */ String $responseString;
            {
                this.this$0 = $receiver;
                this.$responseString = $responseString;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.this$0.getCommandString() + " - Response: " + this.$responseString;
            }
        });
        return this.parseResponse(responseString);
    }

    private final String removeResponseTerminator(String responseString) {
        String string = responseString.substring(0, StringsKt.lastIndexOf$default((CharSequence)responseString, (char)this.getFormat().getTerminator(), (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    protected abstract T parseResponse(@NotNull String var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lxyz/capybara/clamav/commands/Command$CommandFormat;", "", "prefix", "", "terminator", "(Ljava/lang/String;ICC)V", "getPrefix", "()C", "getTerminator", "NULL_CHAR", "NEW_LINE", "Companion", "clamav-client"})
    public static final class CommandFormat
    extends Enum<CommandFormat> {
        @NotNull
        public static final Companion Companion;
        private final char prefix;
        private final char terminator;
        public static final /* enum */ CommandFormat NULL_CHAR;
        public static final /* enum */ CommandFormat NEW_LINE;
        private static final /* synthetic */ CommandFormat[] $VALUES;

        private CommandFormat(char prefix, char terminator) {
            this.prefix = prefix;
            this.terminator = terminator;
        }

        public final char getPrefix() {
            return this.prefix;
        }

        public final char getTerminator() {
            return this.terminator;
        }

        public static CommandFormat[] values() {
            return (CommandFormat[])$VALUES.clone();
        }

        public static CommandFormat valueOf(String value) {
            return Enum.valueOf(CommandFormat.class, value);
        }

        static {
            NULL_CHAR = new CommandFormat('z', '\u0000');
            NEW_LINE = new CommandFormat('n', '\n');
            $VALUES = commandFormatArray = new CommandFormat[]{CommandFormat.NULL_CHAR, CommandFormat.NEW_LINE};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/capybara/clamav/commands/Command$CommandFormat$Companion;", "", "()V", "fromPrefix", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "prefix", "", "clamav-client"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CommandFormat fromPrefix(char prefix) {
                CommandFormat commandFormat;
                char c = prefix;
                if (c == 'z') {
                    commandFormat = NULL_CHAR;
                } else if (c == 'n') {
                    commandFormat = NEW_LINE;
                } else {
                    throw new ClamavException(new IllegalArgumentException(String.valueOf(prefix)));
                }
                return commandFormat;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lxyz/capybara/clamav/commands/Command$Companion;", "Lmu/KLogging;", "()V", "clamav-client"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

