/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.ScanCommand;
import xyz.capybara.clamav.commands.scan.result.ScanResult;
import xyz.capybara.clamav.exceptions.CommunicationException;

public class InStream
extends ScanCommand {
    private static final int CHUNK_SIZE = 2048;
    private InputStream inputStream;

    public InStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public String getCommandString() {
        return "INSTREAM";
    }

    @Override
    protected Command.CommandFormat getFormat() {
        return Command.CommandFormat.NULL_CHAR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ScanResult send(InetSocketAddress server) {
        try (SocketChannel socketChannel = SocketChannel.open(server);){
            socketChannel.write(this.getRawCommand());
            ByteBuffer length = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            byte[] data = new byte[2048];
            int chunkSize = 2048;
            while (chunkSize == 2048) {
                chunkSize = this.inputStream.read(data);
                if (chunkSize <= 0) continue;
                length.clear();
                length.putInt(chunkSize).flip();
                socketChannel.write(length);
                socketChannel.write(ByteBuffer.wrap(data, 0, chunkSize));
            }
            length.clear();
            length.putInt(0).flip();
            socketChannel.write(length);
            ScanResult scanResult = (ScanResult)this.readResponse(socketChannel);
            return scanResult;
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }
}

