/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.exceptions.InvalidResponseException;

public class VersionCommands
extends Command<Collection<String>> {
    private static final String COMMANDS_START_TAG = "| COMMANDS:";

    @Override
    public String getCommandString() {
        return "VERSIONCOMMANDS";
    }

    @Override
    protected Command.CommandFormat getFormat() {
        return Command.CommandFormat.NEW_LINE;
    }

    @Override
    protected Collection<String> parseResponse(String responseString) {
        int commandsStartPos = responseString.indexOf(COMMANDS_START_TAG);
        if (commandsStartPos == -1) {
            throw new InvalidResponseException(responseString);
        }
        return Arrays.stream(responseString.substring(commandsStartPos + COMMANDS_START_TAG.length()).split(" ")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

