/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Pair<T>
implements Iterable<T> {
    public static final Pair EMPTY = new Pair();
    T head;
    Pair<T> tail;

    private Pair() {
        this.head = null;
        this.tail = null;
    }

    public Pair(T head) {
        this.head = head;
        this.tail = Pair.empty();
    }

    public Pair(T head, Pair<T> tail) {
        if (null == tail) {
            throw new NullPointerException("Null tail");
        }
        this.head = head;
        this.tail = tail;
    }

    public int hashCode() {
        Pair<T> pair = this;
        int hash = 1;
        while (EMPTY != pair) {
            T head = pair.head;
            hash = 31 * hash + (null == head ? 0 : head.hashCode());
            pair = pair.tail;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair<T> p1 = this;
        Pair<T> p2 = (Pair<T>)o;
        while (EMPTY != p1 && EMPTY != p2) {
            T h1 = p1.head;
            T h2 = p2.head;
            if (!(null != h1 ? h1.equals(h2) : null == h2)) {
                return false;
            }
            p1 = p1.tail;
            p2 = p2.tail;
        }
        return EMPTY == p1 && EMPTY == p2;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public T head() {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        return this.head;
    }

    public T setHead(T head) {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        T old = this.head;
        this.head = head;
        return old;
    }

    public Pair<T> tail() {
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        return this.tail;
    }

    public Pair<T> setTail(Pair<T> tail) {
        if (null == tail) {
            throw new NullPointerException("Null tail");
        }
        if (this == EMPTY) {
            throw new IllegalStateException("Empty list");
        }
        Pair<T> old = this.tail;
        this.tail = tail;
        return old;
    }

    public T get(int index) {
        if (0 > index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        Pair<T> pair = this;
        int size = 0;
        while (EMPTY != pair) {
            if (index == size) {
                return pair.head;
            }
            ++size;
            pair = pair.tail;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
    }

    public T set(int index, T element) {
        if (0 > index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        Pair<T> pair = this;
        int size = 0;
        while (EMPTY != pair) {
            if (index == size) {
                T old = pair.head;
                pair.head = element;
                return old;
            }
            ++size;
            pair = pair.tail;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
    }

    public int size() {
        Pair<T> pair = this;
        int size = 0;
        while (pair != EMPTY) {
            ++size;
            pair = pair.tail;
        }
        return size;
    }

    public boolean contains(Object o) {
        Pair<T> pair = this;
        while (EMPTY != pair) {
            T head = pair.head;
            if (null == o ? null == head : o.equals(head)) {
                return true;
            }
            pair = pair.tail;
        }
        return false;
    }

    public boolean consists() {
        return EMPTY == this;
    }

    public boolean consists(Object o) {
        return EMPTY != this && (null == o ? null == this.head : o.equals(this.head)) && EMPTY == this.tail;
    }

    public boolean consists(Object o1, Object o2) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != o1 ? o1.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o2 ? o2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object o1, Object o2, Object o3) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != o1 ? o1.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o2 ? o2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o3 ? o3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object o1, Object o2, Object o3, Object o4) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != o1 ? o1.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o2 ? o2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o3 ? o3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o4 ? o4.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object o1, Object o2, Object o3, Object o4, Object o5) {
        Pair<T> pair = this;
        if (EMPTY == pair || !(null != o1 ? o1.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o2 ? o2.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o3 ? o3.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o4 ? o4.equals(pair.head) : null == pair.head)) {
            return false;
        }
        pair = pair.tail;
        if (EMPTY == pair || !(null != o5 ? o5.equals(pair.head) : null == pair.head)) {
            return false;
        }
        return EMPTY == pair.tail;
    }

    public boolean consists(Object ... os) {
        int size;
        Pair<T> pair = this;
        for (size = 0; EMPTY != pair && size < os.length; ++size) {
            T h1 = pair.head;
            Object h2 = os[size];
            if (!(null != h2 ? h2.equals(h1) : null == h1)) {
                return false;
            }
            pair = pair.tail;
        }
        return EMPTY == pair && os.length == size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Pair<T> pair;
            {
                this.pair = Pair.this;
            }

            @Override
            public boolean hasNext() {
                return EMPTY != this.pair;
            }

            @Override
            public T next() {
                if (EMPTY == this.pair) {
                    throw new NoSuchElementException();
                }
                Object h = this.pair.head;
                this.pair = this.pair.tail;
                return h;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Pair<T> reverse() {
        Pair<T> forward = this;
        Pair<T> backward = Pair.empty();
        while (EMPTY != forward) {
            Pair<T> temp = backward;
            backward = forward;
            forward = forward.tail;
            backward.tail = temp;
        }
        return backward;
    }

    public Pair<T> add(T element) {
        if (this == EMPTY) {
            Pair<T> p = new Pair<T>(element);
            return p;
        }
        Pair<T> last = this;
        while (EMPTY != last.tail) {
            last = last.tail;
        }
        last.tail = new Pair<T>(element);
        return last.tail;
    }

    public void setLastTail(Pair<T> tail) {
        if (null == tail) {
            throw new NullPointerException("Null tail");
        }
        if (EMPTY == this) {
            throw new IllegalStateException("Empty list");
        }
        Pair<T> pair = this;
        while (EMPTY != pair.tail) {
            pair = pair.tail;
        }
        pair.tail = tail;
    }

    public Pair<T> append(Pair<T> tail) {
        Pair<T> copy;
        if (null == tail) {
            throw new NullPointerException("Null tail");
        }
        if (EMPTY == this) {
            return tail;
        }
        Pair<T> pair = this;
        Pair<T> cursor = copy = new Pair<T>(pair.head);
        while (EMPTY != pair.tail) {
            pair = pair.tail;
            cursor.tail = new Pair<T>(pair.head);
            cursor = cursor.tail;
        }
        cursor.tail = tail;
        return copy;
    }

    public Pair<T> combine(Pair<T> list) {
        Pair<T> pair = this;
        Pair<T> result = list;
        while (EMPTY != pair) {
            T head = pair.head;
            if (!list.contains(head)) {
                result = new Pair<T>(head, result);
            }
            pair = pair.tail;
        }
        return result;
    }

    public Pair<T> intersect(Pair<T> list) {
        Pair<T> pair = this;
        Pair<T> result = Pair.empty();
        while (EMPTY != pair) {
            T head = pair.head;
            if (list.contains(head)) {
                result = new Pair<T>(head, result);
            }
            pair = pair.tail;
        }
        return result;
    }

    public Pair<T> subtract(Pair<T> list) {
        Pair<T> pair = this;
        Pair<T> result = Pair.empty();
        while (EMPTY != pair) {
            T head = pair.head;
            if (!list.contains(head)) {
                result = new Pair<T>(head, result);
            }
            pair = pair.tail;
        }
        return result;
    }

    public void addTo(List<? super T> l) {
        Pair<T> p = this;
        while (EMPTY != p) {
            l.add(p.head);
            p = p.tail;
        }
    }

    public List<T> list() {
        ArrayList l = new ArrayList(this.size());
        this.addTo(l);
        return l;
    }

    public String toString() {
        Pair<T> pair = this;
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        while (EMPTY != pair) {
            T head = pair.head;
            buf.append(null == head ? "null" : head.toString());
            pair = pair.tail;
            if (EMPTY == pair) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public static final <T> Pair<T> empty() {
        return EMPTY;
    }
}

