/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.IOException;

public class Location
implements Comparable {
    public final String file;
    public final int line;
    public final int column;

    public Location(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public int hashCode() {
        return this.file.hashCode() + this.line * 7 + this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!this.file.equals(other.file)) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return this.column == other.column;
    }

    public int compareTo(Object o) {
        Location other = (Location)o;
        if (!this.file.equals(other.file)) {
            return this.file.compareTo(other.file);
        }
        if (this.line != other.line) {
            return this.line < other.line ? -1 : 1;
        }
        return this.column < other.column ? -1 : (this.column == other.column ? 0 : 1);
    }

    public void write(Appendable out) throws IOException {
        out.append(this.file);
        out.append(':');
        out.append(Integer.toString(this.line));
        out.append(':');
        out.append(Integer.toString(this.column));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.file);
        buf.append(':');
        buf.append(this.line);
        buf.append(':');
        buf.append(this.column);
        return buf.toString();
    }
}

