/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.CharConversionException;
import org.apache.xmlbeans.impl.piccolo.io.CharsetDecoder;
import org.apache.xmlbeans.impl.piccolo.xml.XMLDecoder;

public final class ASCIIXMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new ASCIIXMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    public void reset() {
        this.sawCR = false;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        this.internalDecode(in_buf, in_off, in_len, out_buf, out_off, out_len, result, false);
    }

    public void decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        this.internalDecode(in_buf, in_off, in_len, out_buf, out_off, out_len, result, true);
    }

    private void internalDecode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result, boolean decodeDecl) throws CharConversionException {
        int i;
        int o = 0;
        block5: for (i = 0; i < in_len && o < out_len; ++i) {
            char c = (char)(0x7F & in_buf[in_off + i]);
            if (c >= ' ') {
                this.sawCR = false;
                out_buf[out_off + o++] = c;
                continue;
            }
            switch (c) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case '\r': {
                    this.sawCR = true;
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case '\t': {
                    out_buf[out_off + o++] = 9;
                    continue block5;
                }
                default: {
                    if (decodeDecl) break block5;
                    throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
        }
        result[0] = i;
        result[1] = o;
    }
}

