/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.impl.config.InterfaceExtension;
import org.apache.xmlbeans.impl.config.PrePostExtension;
import org.apache.xmlbeans.impl.config.SchemaConfig;

public class ExtensionHolder {
    private List _interfaceExtensions = new ArrayList();
    private List _prePostExtensions = new ArrayList();

    ExtensionHolder() {
    }

    void addInterfaceExtension(InterfaceExtension ext) {
        if (ext == null) {
            return;
        }
        this._interfaceExtensions.add(ext);
    }

    void addPrePostExtension(PrePostExtension ext) {
        if (ext == null) {
            return;
        }
        this._prePostExtensions.add(ext);
    }

    void secondPhaseValidation() {
        int j;
        int i;
        HashMap<MethodSignature, MethodSignature> methodSignatures = new HashMap<MethodSignature, MethodSignature>();
        for (i = 0; i < this._interfaceExtensions.size(); ++i) {
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            for (j = 0; j < interfaceExtension.getInterfaceMethodCount(); ++j) {
                MethodSignature ms = new MethodSignature(interfaceExtension.getInterfaceName(), interfaceExtension.getInterfaceMethod(j));
                if (methodSignatures.containsKey(ms)) {
                    MethodSignature ms2 = (MethodSignature)methodSignatures.get(ms);
                    SchemaConfig.error("Colliding methods '" + ms.getSignature() + "' in interfaces " + ms.getInterfaceName() + " and " + ms2.getInterfaceName() + ".", null);
                    return;
                }
                methodSignatures.put(ms, ms);
            }
        }
        for (i = 0; i < this._prePostExtensions.size() - 1; ++i) {
            PrePostExtension a = (PrePostExtension)this._prePostExtensions.get(i);
            for (j = 1; j < this._prePostExtensions.size(); ++j) {
                PrePostExtension b = (PrePostExtension)this._prePostExtensions.get(j);
                if (!a.hasNameSetIntersection(b)) continue;
                SchemaConfig.error("The applicable domain for handler '" + a.getHandlerNameForJavaSource() + "' intersects with the one for '" + b.getHandlerNameForJavaSource() + "'.", null);
            }
        }
    }

    void normalize() {
        throw new RuntimeException("NYI");
    }

    public void verifyInterfaceNameCollisions(Set genedUsedNames) {
        String handlerClassName;
        int i;
        for (i = 0; i < this._interfaceExtensions.size(); ++i) {
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (genedUsedNames.contains(interfaceExtension.getInterfaceNameForJavaSource().toLowerCase())) {
                SchemaConfig.error("Extension interface '" + interfaceExtension.getInterfaceNameForJavaSource() + "' creates a name collision with one of the generated interfaces or classes.", null);
            }
            if ((handlerClassName = interfaceExtension.getHandlerNameForJavaSource()) == null || !genedUsedNames.contains(handlerClassName.toLowerCase())) continue;
            SchemaConfig.error("Handler class '" + handlerClassName + "' creates a name collision with one of the generated interfaces or classes.", null);
        }
        for (i = 0; i < this._prePostExtensions.size(); ++i) {
            PrePostExtension prePostExtension = (PrePostExtension)this._prePostExtensions.get(i);
            handlerClassName = prePostExtension.getHandlerNameForJavaSource();
            if (handlerClassName == null || !genedUsedNames.contains(handlerClassName.toLowerCase())) continue;
            SchemaConfig.error("Handler class '" + prePostExtension.getHandlerNameForJavaSource() + "' creates a name collision with one of the generated interfaces or classes.", null);
        }
    }

    ExtensionHolder extensionHolderFor(String javaName) {
        int i;
        for (i = 0; i < this._interfaceExtensions.size(); ++i) {
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (!interfaceExtension.contains(javaName)) continue;
            return this;
        }
        for (i = 0; i < this._prePostExtensions.size(); ++i) {
            PrePostExtension prePostExtension = (PrePostExtension)this._prePostExtensions.get(i);
            if (!prePostExtension.contains(javaName)) continue;
            return this;
        }
        return null;
    }

    public List getInterfaceExtensionsFor(String fullJavaName) {
        ArrayList<InterfaceExtension> result = new ArrayList<InterfaceExtension>();
        for (int i = 0; i < this._interfaceExtensions.size(); ++i) {
            InterfaceExtension intfExt = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (!intfExt.contains(fullJavaName)) continue;
            result.add(intfExt);
        }
        return result;
    }

    public PrePostExtension getPrePostExtensionsFor(String fullJavaName) {
        for (int i = 0; i < this._prePostExtensions.size(); ++i) {
            PrePostExtension prePostExt = (PrePostExtension)this._prePostExtensions.get(i);
            if (!prePostExt.contains(fullJavaName)) continue;
            return prePostExt;
        }
        return null;
    }

    private static class MethodSignature {
        private String _intfName;
        private Method _method;

        MethodSignature(String intfName, Method method) {
            if (intfName == null || method == null) {
                throw new IllegalArgumentException("Interface: " + intfName + " method: " + method);
            }
            this._intfName = intfName;
            this._method = method;
        }

        String getInterfaceName() {
            return this._intfName;
        }

        String getSignature() {
            String sig = "";
            Class<?>[] paramTypes = this._method.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                sig = sig + (i == 0 ? "" : " ,") + paramType.getName();
            }
            return this._method.getName() + "(" + sig + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature ms = (MethodSignature)o;
            if (!ms._method.getName().equals(this._method.getName())) {
                return false;
            }
            Class<?>[] paramTypes = this._method.getParameterTypes();
            Class<?>[] msParamTypes = this._method.getParameterTypes();
            if (msParamTypes.length != paramTypes.length) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                if (msParamTypes[i] == paramTypes[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = this._method.getName().hashCode();
            Class<?>[] paramTypes = this._method.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                hash *= 19;
                hash += paramTypes[i].hashCode();
            }
            return hash;
        }
    }
}

