/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.ConfigDocument;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.Extensionconfig;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.Nsconfig;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.Qnameconfig;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.config.ExtensionHolder;
import org.apache.xmlbeans.impl.config.InterfaceExtension;
import org.apache.xmlbeans.impl.config.NameSet;
import org.apache.xmlbeans.impl.config.NameSetBuilder;
import org.apache.xmlbeans.impl.config.PrePostExtension;
import org.apache.xmlbeans.impl.schema.StscState;

public class SchemaConfig {
    private Map _packageMap;
    private Map _prefixMap;
    private Map _suffixMap;
    private Map _qnameMap;
    private ExtensionHolder _extensionHolder;

    private SchemaConfig() {
        this._packageMap = Collections.EMPTY_MAP;
        this._prefixMap = Collections.EMPTY_MAP;
        this._suffixMap = Collections.EMPTY_MAP;
        this._qnameMap = Collections.EMPTY_MAP;
        this._extensionHolder = null;
    }

    public static SchemaConfig forConfigDocuments(ConfigDocument.Config[] configs) {
        return new SchemaConfig(configs);
    }

    private SchemaConfig(ConfigDocument.Config[] configs) {
        this._packageMap = new LinkedHashMap();
        this._prefixMap = new LinkedHashMap();
        this._suffixMap = new LinkedHashMap();
        this._qnameMap = new LinkedHashMap();
        this._extensionHolder = new ExtensionHolder();
        int i = 0;
        while (i < configs.length) {
            ConfigDocument.Config config = configs[i];
            Nsconfig[] nsa = config.getNamespaceArray();
            int j = 0;
            while (j < nsa.length) {
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getPackage(), this._packageMap);
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getPrefix(), this._prefixMap);
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getSuffix(), this._suffixMap);
                ++j;
            }
            Qnameconfig[] qnc = config.getQnameArray();
            int j2 = 0;
            while (j2 < qnc.length) {
                this._qnameMap.put(qnc[j2].getName(), qnc[j2].getJavaname());
                ++j2;
            }
            Extensionconfig[] ext = config.getExtensionArray();
            int j3 = 0;
            while (j3 < ext.length) {
                this.recordExtensionSetting(ext[j3]);
                ++j3;
            }
            ++i;
        }
        this._extensionHolder.secondPhaseValidation();
    }

    private static void recordNamespaceSetting(Object key, String value, Map result) {
        if (value == null) {
            return;
        }
        if (key == null) {
            result.put("", value);
        } else if (key instanceof String && "##any".equals(key)) {
            result.put(key, value);
        } else if (key instanceof List) {
            Iterator i = ((List)key).iterator();
            while (i.hasNext()) {
                String uri = (String)i.next();
                if ("##local".equals(uri)) {
                    uri = "";
                }
                result.put(uri, value);
            }
        }
    }

    private void recordExtensionSetting(Extensionconfig ext) {
        NameSet xbeanSet = null;
        Object key = ext.getFor();
        if (key instanceof String && "*".equals(key)) {
            xbeanSet = NameSet.EVERYTHING;
        } else if (key instanceof List) {
            NameSetBuilder xbeanSetBuilder = new NameSetBuilder();
            Iterator i = ((List)key).iterator();
            while (i.hasNext()) {
                String xbeanName = (String)i.next();
                xbeanSetBuilder.add(xbeanName);
            }
            xbeanSet = xbeanSetBuilder.toNameSet();
        }
        if (xbeanSet == null) {
            SchemaConfig.error("Invalid value of attribute 'for' : '" + key + "'.", ext);
        }
        Extensionconfig.Interface[] intfXO = ext.getInterfaceArray();
        int i = 0;
        while (i < intfXO.length) {
            this._extensionHolder.addInterfaceExtension(InterfaceExtension.newInstance(xbeanSet, intfXO[i]));
            ++i;
        }
        this._extensionHolder.addPrePostExtension(PrePostExtension.newInstance(xbeanSet, ext.getPrePostSet()));
    }

    private String lookup(Map map, String uri) {
        String result;
        if (uri == null) {
            uri = "";
        }
        if ((result = (String)map.get(uri)) != null) {
            return result;
        }
        return (String)map.get("##any");
    }

    static void warning(String s, XmlObject xo) {
        StscState.get().error(s, 1, xo);
    }

    static void error(String s, XmlObject xo) {
        StscState.get().error(s, 0, xo);
    }

    public String lookupPackageForNamespace(String uri) {
        return this.lookup(this._packageMap, uri);
    }

    public String lookupPrefixForNamespace(String uri) {
        return this.lookup(this._prefixMap, uri);
    }

    public String lookupSuffixForNamespace(String uri) {
        return this.lookup(this._suffixMap, uri);
    }

    public String lookupJavanameForQName(QName qname) {
        return (String)this._qnameMap.get(qname);
    }

    public ExtensionHolder extensionHolderFor(String fullJavaName) {
        return this._extensionHolder.extensionHolderFor(fullJavaName);
    }

    public ExtensionHolder getExtensionHolder() {
        return this._extensionHolder;
    }
}

