/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";
    List _filterTypes = new ArrayList();
    List _filterNodes = new ArrayList();
    Set _F = null;
    List _ancestors = null;
    private static final String FUnion = "union";
    private static final String FSubtract = "subtract";
    private static final String FIntersect = "intersect";
    Set _inputSet = null;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            Object object;
            Object object2;
            this._inputSet = xMLSignatureInput.getNodeSet(true);
            if (this._inputSet.size() == 0) {
                return xMLSignatureInput;
            }
            CachedXPathFuncHereAPI cachedXPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Document document = XMLUtils.getOwnerDocument(this._inputSet);
            Element[] elementArray = XMLUtils.selectNodes(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath");
            int n = elementArray.length;
            if (n == 0) {
                Object[] objectArray = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            this._filterTypes.add(FUnion);
            HelperNodeList helperNodeList = new HelperNodeList();
            helperNodeList.appendChild(document);
            this._filterNodes.add(helperNodeList);
            for (int i = 0; i < n; ++i) {
                object2 = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath", i);
                object = XPath2FilterContainer.newInstance((Element)object2, xMLSignatureInput.getSourceURI());
                if (((XPath2FilterContainer)object).isIntersect()) {
                    this._filterTypes.add(FIntersect);
                } else if (((XPath2FilterContainer)object).isSubtract()) {
                    this._filterTypes.add(FSubtract);
                } else if (((XPath2FilterContainer)object).isUnion()) {
                    this._filterTypes.add(FUnion);
                } else {
                    this._filterTypes.add(null);
                }
                NodeList nodeList = cachedXPathFuncHereAPI.selectNodeList(document, ((XPath2FilterContainer)object).getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(((XPath2FilterContainer)object).getXPathFilterTextNode()), ((ElementProxy)object).getElement());
                this._filterNodes.add(nodeList);
            }
            this._F = new HashSet();
            this._ancestors = new ArrayList();
            this.traversal(document);
            HashSet<Object> hashSet = new HashSet<Object>();
            object2 = this._inputSet.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!this._F.contains(object)) continue;
                hashSet.add(object);
            }
            object = new XMLSignatureInput(hashSet);
            ((XMLSignatureInput)object).setSourceURI(xMLSignatureInput.getSourceURI());
            return object;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
    }

    private void traversal(Node node) {
        int n;
        int n2;
        this._ancestors.add(node);
        if (this._inputSet.contains(node)) {
            int n3 = this._filterTypes.size();
            n2 = 0;
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                NodeList nodeList = (NodeList)this._filterNodes.get(n2);
                String string = (String)this._filterTypes.get(n2);
                if (string == FUnion && this.rooted(this._ancestors, nodeList)) break;
            }
            if ((n = n2) == -1) {
                n = 0;
            }
            boolean bl = true;
            for (int i = n; i < n3; ++i) {
                NodeList nodeList = (NodeList)this._filterNodes.get(i);
                String string = (String)this._filterTypes.get(i);
                boolean bl2 = this.rooted(this._ancestors, nodeList);
                if (string == FIntersect && !bl2) {
                    bl = false;
                    break;
                }
                if (string != FSubtract || !bl2) continue;
                bl = false;
                break;
            }
            if (bl) {
                this._F.add(node);
            }
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                this.traversal(node2);
            }
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            this.traversal(node3);
        }
        this._ancestors.remove(node);
    }

    boolean rooted(List list, NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!list.contains(node)) continue;
            return true;
        }
        return false;
    }
}

