/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.Channel;

public class HermesGc {
    private static volatile HermesGc sInstance = null;
    private final ReferenceQueue<Object> mReferenceQueue = new ReferenceQueue();
    private static final Channel CHANNEL = Channel.getInstance();
    private final ConcurrentHashMap<PhantomReference<Object>, Long> mTimeStamps = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Class<? extends HermesService>> mServices = new ConcurrentHashMap();

    private HermesGc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HermesGc getInstance() {
        if (sInstance != null) return sInstance;
        Class<HermesGc> clazz = HermesGc.class;
        synchronized (HermesGc.class) {
            if (sInstance != null) return sInstance;
            sInstance = new HermesGc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc() {
        ReferenceQueue<Object> referenceQueue = this.mReferenceQueue;
        synchronized (referenceQueue) {
            Reference<Object> reference;
            HashMap<Class<? extends HermesService>, ArrayList<Long>> timeStamps = new HashMap<Class<? extends HermesService>, ArrayList<Long>>();
            while ((reference = this.mReferenceQueue.poll()) != null) {
                Class<? extends HermesService> clazz;
                Long timeStamp = this.mTimeStamps.remove(reference);
                if (timeStamp == null || (clazz = this.mServices.remove(timeStamp)) == null) continue;
                ArrayList<Long> tmp = (ArrayList<Long>)timeStamps.get(clazz);
                if (tmp == null) {
                    tmp = new ArrayList<Long>();
                    timeStamps.put(clazz, tmp);
                }
                tmp.add(timeStamp);
            }
            Set set = timeStamps.entrySet();
            for (Map.Entry entry : set) {
                ArrayList values = (ArrayList)entry.getValue();
                if (values.isEmpty()) continue;
                CHANNEL.gc((Class)entry.getKey(), values);
            }
        }
    }

    public void register(Class<? extends HermesService> service, Object object, Long timeStamp) {
        this.gc();
        this.mTimeStamps.put(new PhantomReference<Object>(object, this.mReferenceQueue), timeStamp);
        this.mServices.put(timeStamp, service);
    }
}

