/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.wsdl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import org.codehaus.xfire.java.wsdl.WSDLType;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class AbstractWSDL
implements WSDLWriter {
    private Definition def;
    private String targetNamespace;
    private Service service;
    private Document wsdlDocument;
    private Map dependencies;
    private Element schemaTypes;
    private Map typeMap;
    protected Namespace xsdNs = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    protected QName schemaQ = new QName("schema", this.xsdNs);
    protected QName elementQ = new QName("element", this.xsdNs);
    protected QName xfireTypeQ = QName.get((String)"xfire", (String)"http://xfire.codehaus.org");

    public AbstractWSDL(Service service) throws WSDLException {
        this.dependencies = new HashMap();
        this.service = service;
        this.setDefinition(WSDLFactory.newInstance().newDefinition());
        this.getDefinition().setTargetNamespace(service.getDefaultNamespace());
        Document paramDoc = DocumentFactory.getInstance().createDocument();
        this.setSchemaTypes(paramDoc.addElement("root"));
        this.getSchemaTypes().add(this.xsdNs);
        this.addNamespace("soap", service.getSoapVersion().getNamespace());
        this.addNamespace("soapenc", service.getSoapVersion().getSoapEncodingStyle());
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("tns", service.getDefaultNamespace());
        this.typeMap = new HashMap();
    }

    protected void writeDocument() throws WSDLException {
        org.w3c.dom.Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.def);
        this.wsdlDocument = new DOMReader().read(doc);
        this.wsdlDocument.getRootElement().addNamespace("tns", this.service.getDefaultNamespace());
        this.writeComplexTypes();
    }

    protected void writeComplexTypes() throws WSDLException {
        Element rootEl = this.getDocument().getRootElement();
        Namespace wsdlNs = rootEl.getNamespaceForURI("http://schemas.xmlsoap.org/wsdl/");
        QName typeQ = new QName("types", wsdlNs);
        Element types = rootEl.addElement(typeQ);
        List list = rootEl.content();
        list.remove(types);
        list.set(0, types);
        Iterator nsItr = this.typeMap.keySet().iterator();
        while (nsItr.hasNext()) {
            String schemaNs = (String)nsItr.next();
            Element schema = types.addElement(this.schemaQ);
            schema.addAttribute("targetNamespace", schemaNs);
            schema.addAttribute("elementFormDefault", "qualified");
            schema.addAttribute("attributeFormDefault", "qualified");
            this.writeSchemaForNamespace(schema, schemaNs);
        }
    }

    public void addDependency(WSDLType type) {
        Set deps;
        if (!type.isComplex()) {
            return;
        }
        if (!this.dependencies.containsKey(type.getSchemaType())) {
            this.dependencies.put(type.getSchemaType(), type);
            Element e = this.createSchemaType(type.getSchemaType().getNamespaceURI());
            type.writeSchema(e);
        }
        if ((deps = type.getDependencies()) != null) {
            Iterator itr = deps.iterator();
            while (itr.hasNext()) {
                this.addDependency((WSDLType)itr.next());
            }
        }
    }

    protected void writeSchemaForNamespace(Element schema, String schemaNs) {
        List types = (List)this.typeMap.get(schemaNs);
        if (types != null) {
            Iterator itr = types.iterator();
            while (itr.hasNext()) {
                Element el = (Element)itr.next();
                Iterator eitr = el.elements().iterator();
                while (eitr.hasNext()) {
                    Node n = ((Element)eitr.next()).detach();
                    schema.add(n);
                }
                Namespace ns = NamespaceHelper.getNamespace((Element)el, (String)schemaNs);
                this.getDocument().getRootElement().add(ns);
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        XMLWriter writer = new XMLWriter(OutputFormat.createCompactFormat());
        writer.setOutputStream(out);
        writer.write(this.getDocument());
        writer.flush();
    }

    public void addNamespace(String prefix, String uri) {
        this.def.addNamespace(prefix, uri);
        this.schemaTypes.addNamespace(prefix, uri);
    }

    public Namespace getNamespace(String uri) {
        return NamespaceHelper.getNamespace((Element)this.schemaTypes, (String)uri);
    }

    public Document getDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public void setDefinition(Definition definition) {
        this.def = definition;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Element createSchemaType(String namespace) {
        Element e = this.getSchemaTypes().addElement(this.xfireTypeQ);
        ArrayList<Element> types = (ArrayList<Element>)this.typeMap.get(namespace);
        if (types == null) {
            types = new ArrayList<Element>();
            this.typeMap.put(namespace, types);
        }
        types.add(e);
        return e;
    }

    protected Element getSchemaTypes() {
        return this.schemaTypes;
    }

    protected void setSchemaTypes(Element schemaTypes) {
        this.schemaTypes = schemaTypes;
    }
}

