/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.Parameter;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.java.wsdl.WSDLBuilder;
import org.codehaus.xfire.service.SimpleService;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class DefaultJavaService
extends SimpleService
implements JavaService {
    private TypeMappingRegistry typeMappingRegistry;
    private TypeMapping typeMapping;
    private List allowedMethods = new ArrayList();
    private Class serviceClass;
    private Hashtable operations = new Hashtable();
    private WSDLBuilder wsdlBuilder;
    private boolean autoTyped = false;
    private int scope = 1;

    public DefaultJavaService() {
    }

    public DefaultJavaService(TypeMappingRegistry registry) {
        this.typeMappingRegistry = registry;
    }

    public void setServiceClass(String className) throws ClassNotFoundException {
        this.setServiceClass(this.loadClass(className));
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void initializeOperations() {
        Method[] methods = this.serviceClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            if (!this.isAllowed(methodName) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.addOperation(method);
        }
    }

    protected void addOperation(Method method) {
        QName q;
        Type t;
        String ns;
        Operation op = new Operation(method, this);
        this.operations.put(method.getName(), op);
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = this.getStyle().equals("document");
        for (int j = 0; j < paramClasses.length; ++j) {
            String paramName = "";
            if (isDoc) {
                paramName = method.getName();
            }
            paramName = paramName + "in" + j;
            ns = this.getDefaultNamespace();
            t = this.getTypeMapping().getType(paramClasses[j]);
            if (t.isComplex()) {
                ns = t.getSchemaType().getNamespaceURI();
            }
            q = new QName(ns, paramName);
            Parameter p = new Parameter(q, t);
            op.addInParameter(p);
        }
        Class<Void> returnType = method.getReturnType();
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            String outName = "";
            if (isDoc) {
                outName = method.getName();
            }
            ns = this.getDefaultNamespace();
            t = this.getTypeMapping().getType(method.getReturnType());
            if (t.isComplex()) {
                ns = t.getSchemaType().getNamespaceURI();
            }
            q = new QName(ns, outName + "out");
            Parameter outP = new Parameter(q, t);
            op.addOutParameter(outP);
        }
    }

    private boolean isAllowed(String methodName) {
        return this.allowedMethods.size() == 0 || this.allowedMethods.contains(methodName);
    }

    public Operation getOperation(String localName, String namespace) {
        return (Operation)this.operations.get(localName);
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    protected Map getOperationsMap() {
        return this.operations;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnf2) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
    }

    public void initializeTypeMapping() {
        TypeMapping tm = null;
        if (this.getUse() != null) {
            tm = this.getUse().equals("encoded") ? this.getTypeMappingRegistry().createTypeMapping(this.getSoapVersion().getSoapEncodingStyle(), this.autoTyped) : this.getTypeMappingRegistry().createTypeMapping("http://www.w3.org/2001/XMLSchema", this.autoTyped);
            this.setTypeMapping(tm);
            this.getTypeMappingRegistry().register(this.getDefaultNamespace(), tm);
        }
    }

    public WSDLWriter getWSDLWriter() throws WSDLException {
        WSDLBuilder b;
        WSDLWriter writer = super.getWSDLWriter();
        if (writer == null && (b = this.getWSDLBuilder()) != null) {
            return this.getWSDLBuilder().createWSDLWriter(this);
        }
        return writer;
    }

    public boolean isAutoTyped() {
        return this.autoTyped;
    }

    public void setAutoTyped(boolean autoTyped) {
        this.autoTyped = autoTyped;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public WSDLBuilder getWSDLBuilder() {
        return this.wsdlBuilder;
    }

    public void setWSDLBuilder(WSDLBuilder wsdlBuilder) {
        this.wsdlBuilder = wsdlBuilder;
    }
}

