/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.util.DateUtils;

public class LiteralWriter
implements MessageWriter {
    private XMLStreamWriter writer;
    private String namespace;
    private String name;
    private static Calendar calendar = Calendar.getInstance();

    public LiteralWriter(XMLStreamWriter writer, String name, String namespace) {
        this.writer = writer;
        this.namespace = namespace;
        this.name = name;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    private void writeStartElement() throws XMLStreamException {
        String prefix = this.writer.getPrefix(this.namespace);
        boolean writeNS = false;
        if (prefix == null) {
            prefix = "";
            this.writer.setPrefix(prefix, this.namespace);
            writeNS = true;
        }
        this.writer.writeStartElement("", this.name, this.namespace);
        if (writeNS) {
            this.writer.writeDefaultNamespace(this.namespace);
        }
    }

    public void writeValue(Object value) {
        try {
            if (value != null) {
                this.writer.writeCharacters(value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    public MessageWriter getChildWriter(String name) {
        return new LiteralWriter(this.writer, name, this.namespace);
    }

    public MessageWriter getChildWriter(String name, String ns) {
        return new LiteralWriter(this.writer, name, ns);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void writeValueAsCalendar(Calendar calendar) {
        DateUtils.formatDateTime((Date)calendar.getTime());
    }

    public void writeValueAsInt(Integer i) {
        this.writeValue(i.toString());
    }

    public void writeValueAsDateTime(Date date) {
        this.writeValue(DateUtils.formatDateTime((Date)date));
    }

    public void writeValueAsDate(Date date) {
        DateUtils.formatDate((Date)calendar.getTime());
    }

    public void writeValueAsDouble(Double d) {
        this.writeValue(d.toString());
    }

    public void writeValueAsLong(Long l) {
        this.writeValue(l.toString());
    }

    public void writeValueAsFloat(Float f) {
        this.writeValue(f.toString());
    }

    public void writeValueAsBoolean(boolean b) {
        this.writeValue(Boolean.toString(b));
    }

    public void close() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }
}

