/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.util.StringTokenizer;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.fault.FaultHandler;
import org.codehaus.xfire.fault.SOAP11FaultHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.SoapHandler;
import org.codehaus.xfire.java.DefaultJavaService;
import org.codehaus.xfire.java.JavaServiceHandler;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.wsdl.JavaWSDLBuilder;
import org.codehaus.xfire.service.Service;

public class ServiceHelper {
    public static void createService(XFire xfire, TypeMappingRegistry registry, Class serviceClass) throws Exception {
        DefaultJavaService service = new DefaultJavaService();
        String name = serviceClass.getName();
        int last = name.lastIndexOf(".");
        if (last != -1) {
            name = name.substring(last + 1);
        }
        service.setName(name);
        service.setDefaultNamespace(ServiceHelper.makeNamespaceFromClassName(serviceClass.getName(), "http"));
        try {
            service.setServiceClass(serviceClass.getName());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        service.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
        service.setStyle("wrapped");
        service.setUse("literal");
        service.setFaultHandler((FaultHandler)new SOAP11FaultHandler());
        service.setWSDLBuilder(new JavaWSDLBuilder(xfire.getTransportManager()));
        service.setAutoTyped(true);
        SoapHandler handler = new SoapHandler((Handler)new JavaServiceHandler());
        service.setServiceHandler((Handler)handler);
        service.setTypeMappingRegistry(registry);
        service.initialize();
        xfire.getServiceRegistry().register((Service)service);
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        String packageName = className.substring(0, className.lastIndexOf("."));
        if (packageName == null || packageName.equals("")) {
            return protocol + "://" + "DefaultNamespace";
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString();
    }
}

