/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.object.ObjectService;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.type.TypeMapping;
import org.codehaus.xfire.wsdl11.builder.AbstractJavaWSDL;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class DocumentWSDL
extends AbstractJavaWSDL {
    public DocumentWSDL(ObjectService service, Collection transports) throws WSDLException {
        super(service, transports);
    }

    protected void createOutputParts(Message res, Operation op) {
        this.writeParameters(res, op.getOutParameters());
    }

    protected void createInputParts(Message req, Operation op) {
        this.writeParameters(req, op.getInParameters());
    }

    private void writeParameters(Message message, Collection params) {
        ObjectService service = (ObjectService)this.getService();
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            Parameter param = (Parameter)itr.next();
            Class clazz = param.getTypeClass();
            QName pName = param.getName();
            Type type = this.getParameterType(service.getTypeMapping(), param);
            this.addDependency(type);
            QName schemaType = type.getSchemaType();
            Part part = this.getDefinition().createPart();
            part.setName(pName.getLocalPart());
            if (type.isComplex()) {
                part.setElementName(pName);
                Element schemaEl = this.createSchemaType(this.getInfo().getTargetNamespace());
                Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
                schemaEl.appendChild((Node)element);
                element.addAttribute(new Attribute("name", pName.getLocalPart()));
                String prefix = this.getNamespacePrefix(schemaType.getNamespaceURI());
                this.addNamespace(prefix, schemaType.getNamespaceURI());
                element.addAttribute(new Attribute("type", prefix + ":" + schemaType.getLocalPart()));
            } else {
                part.setElementName(type.getSchemaType());
            }
            message.addPart(part);
        }
    }

    private Type getParameterType(TypeMapping tm, Parameter param) {
        Type type = null;
        if (param.getAbstractType() != null) {
            type = tm.getType(param.getAbstractType());
        }
        if (type == null) {
            type = tm.getType(param.getTypeClass());
        }
        return type;
    }
}

