/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.type.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.MessageWriter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.type.basic.ArrayType;

public class ListType
extends ArrayType {
    private Class componentType;

    public ListType(Class componentType) {
        this.componentType = componentType;
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Type compType = this.getComponentType();
            ArrayList<Object> values = new ArrayList<Object>();
            while (reader.hasMoreElementReaders()) {
                MessageReader childReader = reader.getNextElementReader();
                values.add(compType.readObject(childReader, context));
            }
            return values;
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            List list = (List)object;
            Type type = this.getComponentType();
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + type.getTypeClass() + ".");
            }
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                String ns = null;
                ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                MessageWriter cwriter = writer.getElementWriter(type.getSchemaType().getLocalPart(), ns);
                type.writeObject(itr.next(), writer, context);
                cwriter.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    protected Type getComponentType() {
        return this.getTypeMapping().getType(this.componentType);
    }
}

