/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSAttributeUse;
import org.apache.xerces.impl.xs.psvi.XSComplexTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSFacet;
import org.apache.xerces.impl.xs.psvi.XSIDCDefinition;
import org.apache.xerces.impl.xs.psvi.XSModel;
import org.apache.xerces.impl.xs.psvi.XSModelGroup;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSMultiValueFacet;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItemList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSParticle;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSWildcard;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PSVIWriter
implements XMLComponent,
XMLDocumentFilter {
    public static final String XERCES_PSVI_NS = "http://apache.org/xml/2001/PSVInfosetExtension";
    protected static final String PSVINFOSET = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected boolean fIncludeIgnorableWhitespace;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/dom/include-ignorable-whitespace", "http://apache.org/xml/features/validation/schema/augment-psvi"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[0];
    private static final Object[] PROPERTY_DEFAULTS = new Object[0];
    protected boolean fPSVInfoset;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected NamespaceContext fNamespaceContext;
    protected NamespaceContext fPSVINamespaceContext;
    protected XMLLocator fDocumentLocation;
    private Stack _elementState = new Stack();
    protected int fAnonNum;
    protected int fIndent;
    protected HashMap fIDMap;
    protected Vector fDefined;
    private char[] fIndentChars = new char[]{'\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t'};
    private XMLString newLine = new XMLString(new char[]{'\n'}, 0, 1);

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fPSVInfoset = xMLComponentManager.getFeature(PSVINFOSET);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fPSVInfoset = false;
        }
        this.fIncludeIgnorableWhitespace = xMLComponentManager.getFeature(INCLUDE_IGNORABLE_WHITESPACE);
        this.fAnonNum = 1000;
        this.fIDMap = new HashMap();
        this.fDefined = new Vector();
        this.fIndent = 0;
        this.fPSVINamespaceContext = new NamespaceSupport();
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fDocumentLocation = xMLLocator;
        this.fPSVINamespaceContext.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.fPSVINamespaceContext.declarePrefix("psv", XERCES_PSVI_NS);
        this.fPSVINamespaceContext.declarePrefix("", "http://www.w3.org/2001/05/XMLInfoset");
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, "UTF-8", this.fPSVINamespaceContext, null);
        }
        Vector<String> vector = new Vector<String>();
        vector.add("xmlns:xsi");
        vector.add("http://www.w3.org/2001/XMLSchema-instance");
        vector.add(XMLSymbols.fCDATASymbol);
        vector.add("xmlns:psv");
        vector.add(XERCES_PSVI_NS);
        vector.add(XMLSymbols.fCDATASymbol);
        vector.add("xmlns");
        vector.add("http://www.w3.org/2001/05/XMLInfoset");
        vector.add(XMLSymbols.fCDATASymbol);
        this.sendIndentedElement("document", vector);
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.sendElementEvent("characterEncodingScheme", string2);
        this.sendElementEvent("standalone", string3);
        this.sendElementEvent("version", string);
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.checkForChildren();
        this.sendIndentedElement("docTypeDeclaration");
        if (string2 != null) {
            this.sendElementEvent("publicIdentifier", string2);
        }
        if (string3 != null) {
            this.sendElementEvent("systemIdentifier", string3);
        }
        this.sendUnIndentedElement("docTypeDeclaration");
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.checkForChildren();
        this.sendIndentedElement("comment");
        this.sendElementEvent("content", xMLString);
        this.sendUnIndentedElement("comment");
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.checkForChildren();
        this.sendIndentedElement("processingInstruction");
        this.sendElementEvent("target", string);
        this.sendElementEvent("content", xMLString);
        this.sendUnIndentedElement("processingInstruction");
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (xMLAttributes == null) {
            System.err.println("null attributes!");
        }
        this.checkForChildren();
        this._elementState.push(new ElementState(true));
        this.sendIndentedElement("element");
        this.sendElementEvent("namespaceName", qName.uri);
        this.sendElementEvent("localName", qName.localpart);
        this.sendElementEvent("prefix", qName.prefix);
        this.processAttributes(xMLAttributes);
        this.processInScopeNamespaces();
        this.sendElementEvent("baseURI", this.fDocumentLocation.getBaseSystemId());
        if (this.fPSVInfoset) {
            this.processPSVIStartElement(augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.sendIndentedElement("element");
        this.sendElementEvent("namespaceName", qName.uri);
        this.sendElementEvent("localName", qName.localpart);
        this.sendElementEvent("prefix", qName.prefix);
        this.processAttributes(xMLAttributes);
        this.processInScopeNamespaces();
        this.sendElementEvent("baseURI", this.fDocumentLocation.getBaseSystemId());
        if (this.fPSVInfoset) {
            this.processPSVIStartElement(augmentations);
        }
        this.sendEmptyElementEvent("children");
        if (this.fPSVInfoset) {
            this.processPSVIEndElement(augmentations);
        }
        this.sendUnIndentedElement("element");
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.checkForChildren();
        this.sendIndentedElement("character");
        this.sendElementEvent("textContent", xMLString);
        this.sendUnIndentedElement("character");
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fIncludeIgnorableWhitespace) {
            this.characters(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        ElementState elementState = (ElementState)this._elementState.peek();
        if (elementState.isEmpty) {
            this.sendEmptyElementEvent("children");
        } else {
            this.sendUnIndentedElement("children");
        }
        this._elementState.pop();
        if (this.fPSVInfoset) {
            this.processPSVIStartElement(augmentations);
            this.processPSVIEndElement(augmentations);
        }
        this.sendUnIndentedElement("element");
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.sendUnIndentedElement("children");
        this.sendElementEvent("documentElement");
        this.sendEmptyElementEvent("notations");
        this.sendEmptyElementEvent("unparsedEntities");
        this.sendElementEvent("baseURI", this.fDocumentLocation.getBaseSystemId());
        this.sendElementEvent("allDeclarationsProcessed", "true");
        this.sendUnIndentedElement("document");
        this.fDocumentHandler.endDocument(null);
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
    }

    private void processAttributes(XMLAttributes xMLAttributes) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = n = xMLAttributes == null ? 0 : xMLAttributes.getLength();
        if (n == 0) {
            this.sendEmptyElementEvent("attributes");
            this.sendEmptyElementEvent("namespaceAttributes");
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            String string = xMLAttributes.getLocalName(n3);
            String string2 = xMLAttributes.getPrefix(n3);
            if (string2 == XMLSymbols.PREFIX_XMLNS || string == XMLSymbols.PREFIX_XMLNS) {
                bl = true;
            } else {
                if (!bl2) {
                    this.sendIndentedElement("attributes");
                }
                this.sendIndentedElement("attribute");
                this.sendElementEvent("namespaceName", xMLAttributes.getURI(n3));
                this.sendElementEvent("localName", xMLAttributes.getLocalName(n3));
                this.sendElementEvent("prefix", xMLAttributes.getPrefix(n3));
                this.sendElementEvent("normalizedValue", xMLAttributes.getValue(n3));
                this.sendElementEvent("specified", String.valueOf(xMLAttributes.isSpecified(n3)));
                this.sendElementEvent("attributeType", xMLAttributes.getType(n3));
                this.sendElementEvent("references");
                if (this.fPSVInfoset) {
                    this.processPSVIAttribute(xMLAttributes.getAugmentations(n3));
                }
                this.sendUnIndentedElement("attribute");
                bl2 = true;
            }
            ++n3;
        }
        if (bl2) {
            this.sendUnIndentedElement("attributes");
        } else {
            this.sendEmptyElementEvent("attributes");
        }
        if (bl) {
            this.processNamespaceAttributes(xMLAttributes);
        } else {
            this.sendEmptyElementEvent("namespaceAttributes");
        }
    }

    private void processNamespaceAttributes(XMLAttributes xMLAttributes) {
        int n = xMLAttributes.getLength();
        this.sendIndentedElement("namespaceAttributes");
        int n2 = 0;
        while (n2 < n) {
            String string = xMLAttributes.getLocalName(n2);
            String string2 = xMLAttributes.getPrefix(n2);
            if (string2 == XMLSymbols.PREFIX_XMLNS || string == XMLSymbols.PREFIX_XMLNS) {
                this.sendIndentedElement("attribute");
                this.sendElementEvent("namespaceName", NamespaceContext.XMLNS_URI);
                this.sendElementEvent("localName", string);
                this.sendElementEvent("prefix", string2);
                this.sendElementEvent("normalizedValue", xMLAttributes.getValue(n2));
                this.sendElementEvent("specified", String.valueOf(xMLAttributes.isSpecified(n2)));
                this.sendElementEvent("attributeType", xMLAttributes.getType(n2));
                this.sendElementEvent("references");
                if (this.fPSVInfoset) {
                    this.processPSVIAttribute(xMLAttributes.getAugmentations(n2));
                }
                this.sendUnIndentedElement("attribute");
            }
            ++n2;
        }
        this.sendUnIndentedElement("namespaceAttributes");
    }

    private void processInScopeNamespaces() {
        this.sendIndentedElement("inScopeNamespaces");
        this.sendIndentedElement("namespace");
        this.sendElementEvent("prefix", "xml");
        this.sendElementEvent("namespaceName", NamespaceContext.XML_URI);
        this.sendUnIndentedElement("namespace");
        Enumeration enumeration = this.fNamespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            this.sendIndentedElement("namespace");
            String string = (String)enumeration.nextElement();
            String string2 = this.fNamespaceContext.getURI(string);
            this.sendElementEvent("prefix", string);
            this.sendElementEvent("namespaceName", string2);
            this.sendUnIndentedElement("namespace");
        }
        this.sendUnIndentedElement("inScopeNamespaces");
    }

    private void processPSVIStartElement(Augmentations augmentations) {
        if (augmentations == null) {
            return;
        }
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            // empty if block
        }
    }

    private void processPSVIEndElement(Augmentations augmentations) {
        if (augmentations == null) {
            return;
        }
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            this.processPSVISchemaInformation(elementPSVI);
            this.sendElementEvent("psv:validationAttempted", this.translateValidationAttempted(elementPSVI.getValidationAttempted()));
            this.sendElementEvent("psv:validationContext", elementPSVI.getValidationContext());
            this.sendElementEvent("psv:validity", this.translateValidity(elementPSVI.getValidity()));
            this.processPSVISchemaErrorCode(elementPSVI.getErrorCodes());
            this.sendElementEvent("psv:schemaNormalizedValue", elementPSVI.getSchemaNormalizedValue());
            this.sendElementEvent("psv:schemaSpecified", elementPSVI.getIsSchemaSpecified() ? "schema" : "infoset");
            this.sendElementEvent("psv:schemaDefault", elementPSVI.getSchemaDefault());
            this.processPSVITypeDefinitionRef("psv:typeDefinition", elementPSVI.getTypeDefinition());
            this.processPSVITypeDefinitionRef("psv:memberTypeDefinition", (XSTypeDefinition)elementPSVI.getMemberTypeDefinition());
            this.sendElementEvent("psv:nil");
            this.sendIndentedElement("psv:declaration");
            this.processPSVIElementRef("psv:elementDeclaration", (XSObject)elementPSVI.getElementDeclaration());
            this.sendUnIndentedElement("psv:declaration");
            this.processPSVIElementRef("psv:notation", (XSObject)elementPSVI.getNotation());
            this.sendElementEvent("psv:idIdrefTable");
            this.sendElementEvent("psv:identityConstraintTable");
        }
    }

    private void processPSVIAttribute(Augmentations augmentations) {
        if (augmentations == null) {
            return;
        }
        AttributePSVI attributePSVI = (AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI");
        if (attributePSVI != null) {
            this.sendElementEvent("psv:validationAttempted", this.translateValidationAttempted(attributePSVI.getValidationAttempted()));
            this.sendElementEvent("psv:validationContext", attributePSVI.getValidationContext());
            this.sendElementEvent("psv:validity", this.translateValidity(attributePSVI.getValidity()));
            this.processPSVISchemaErrorCode(attributePSVI.getErrorCodes());
            this.sendElementEvent("psv:schemaNormalizedValue", attributePSVI.getSchemaNormalizedValue());
            this.sendElementEvent("psv:schemaSpecified", attributePSVI.getIsSchemaSpecified() ? "schema" : "infoset");
            this.sendElementEvent("psv:schemaDefault", attributePSVI.getSchemaDefault());
            this.processPSVITypeDefinitionRef("psv:typeDefinition", attributePSVI.getTypeDefinition());
            this.processPSVITypeDefinitionRef("psv:memberTypeDefinition", (XSTypeDefinition)attributePSVI.getMemberTypeDefinition());
            if (attributePSVI.getAttributeDeclaration() == null) {
                this.sendElementEvent("psv:declaration");
            } else {
                this.sendIndentedElement("psv:declaration");
                this.processPSVIAttributeDeclarationRef(attributePSVI.getAttributeDeclaration());
                this.sendUnIndentedElement("psv:declaration");
            }
        }
    }

    private void processPSVISchemaErrorCode(StringList stringList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringList != null && stringList.getLength() > 0) {
            int n = 0;
            while (n < stringList.getLength() - 1) {
                stringBuffer.append(stringList.item(n));
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(stringList.item(stringList.getLength() - 1));
        }
        this.sendElementEvent("psv:schemaErrorCode", stringBuffer.toString());
    }

    private void processPSVISchemaInformation(ElementPSVI elementPSVI) {
        XSNamespaceItemList xSNamespaceItemList;
        if (elementPSVI == null) {
            return;
        }
        XSModel xSModel = elementPSVI.getSchemaInformation();
        XSNamespaceItemList xSNamespaceItemList2 = xSNamespaceItemList = xSModel == null ? null : xSModel.getNamespaceItems();
        if (xSNamespaceItemList == null || xSNamespaceItemList.getLength() == 0) {
            this.sendElementEvent("psv:schemaInformation");
        } else {
            this.sendIndentedElement("psv:schemaInformation");
            int n = 0;
            while (n < xSNamespaceItemList.getLength()) {
                this.processPSVINamespaceItem(xSNamespaceItemList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:schemaInformation");
        }
    }

    private void processPSVINamespaceItem(XSNamespaceItem xSNamespaceItem) {
        if (xSNamespaceItem == null) {
            return;
        }
        String string = xSNamespaceItem.getSchemaNamespace();
        if (string != null && string.equals(Constants.NS_XMLSCHEMA)) {
            return;
        }
        this.sendIndentedElement("psv:namespaceSchemaInformation");
        this.sendElementEvent("psv:schemaNamespace", string);
        this.processPSVISchemaComponents(xSNamespaceItem);
        this.processPSVISchemaDocuments(xSNamespaceItem);
        this.processPSVISchemaAnnotations(xSNamespaceItem.getAnnotations());
        this.sendUnIndentedElement("psv:namespaceSchemaInformation");
    }

    private void processPSVISchemaDocuments(XSNamespaceItem xSNamespaceItem) {
        StringList stringList;
        StringList stringList2 = stringList = xSNamespaceItem == null ? null : xSNamespaceItem.getDocumentLocations();
        if (stringList == null || stringList.getLength() == 0) {
            this.sendEmptyElementEvent("psv:schemaDocuments");
            return;
        }
        this.sendIndentedElement("psv:schemaDocuments");
        int n = 0;
        while (n < stringList.getLength()) {
            this.sendIndentedElement("psv:schemaDocument");
            this.sendElementEvent("psv:documentLocation", stringList.item(n));
            this.sendElementEvent("psv:document");
            this.sendUnIndentedElement("psv:schemaDocument");
            ++n;
        }
        this.sendUnIndentedElement("psv:schemaDocuments");
    }

    private void processPSVISchemaComponents(XSNamespaceItem xSNamespaceItem) {
        if (xSNamespaceItem == null) {
            this.sendEmptyElementEvent("psv:schemaComponents");
            return;
        }
        this.sendIndentedElement("psv:schemaComponents");
        XSNamedMap xSNamedMap = xSNamespaceItem.getComponents((short)3);
        int n = 0;
        while (n < xSNamedMap.getLength()) {
            this.processPSVITypeDefinition((XSTypeDefinition)xSNamedMap.item(n));
            ++n;
        }
        xSNamedMap = xSNamespaceItem.getComponents((short)2);
        int n2 = 0;
        while (n2 < xSNamedMap.getLength()) {
            this.processPSVIElementDeclaration((XSElementDeclaration)xSNamedMap.item(n2));
            ++n2;
        }
        xSNamedMap = xSNamespaceItem.getComponents((short)1);
        int n3 = 0;
        while (n3 < xSNamedMap.getLength()) {
            this.processPSVIAttributeDeclaration((XSAttributeDeclaration)xSNamedMap.item(n3));
            ++n3;
        }
        xSNamedMap = xSNamespaceItem.getComponents((short)6);
        int n4 = 0;
        while (n4 < xSNamedMap.getLength()) {
            this.processPSVIModelGroupDefinition((XSModelGroupDefinition)xSNamedMap.item(n4));
            ++n4;
        }
        xSNamedMap = xSNamespaceItem.getComponents((short)5);
        int n5 = 0;
        while (n5 < xSNamedMap.getLength()) {
            this.processPSVIAttributeGroupDefinition((XSAttributeGroupDefinition)xSNamedMap.item(n5));
            ++n5;
        }
        xSNamedMap = xSNamespaceItem.getComponents((short)11);
        int n6 = 0;
        while (n6 < xSNamedMap.getLength()) {
            this.processPSVINotationDeclaration((XSNotationDeclaration)xSNamedMap.item(n6));
            ++n6;
        }
        this.sendUnIndentedElement("psv:schemaComponents");
    }

    private void processPSVITypeDefinition(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return;
        }
        if (xSTypeDefinition.getTypeCategory() == 13) {
            this.processPSVIComplexTypeDefinition((XSComplexTypeDefinition)xSTypeDefinition);
        } else if (xSTypeDefinition.getTypeCategory() == 14) {
            this.processPSVISimpleTypeDefinition((XSSimpleTypeDefinition)xSTypeDefinition);
        } else {
            throw new IllegalArgumentException("Unknown type definition value: " + xSTypeDefinition.getType());
        }
    }

    private void processPSVIComplexTypeDefinition(XSComplexTypeDefinition xSComplexTypeDefinition) {
        if (xSComplexTypeDefinition == null) {
            return;
        }
        this.sendIndentedElementWithID("psv:complexTypeDefinition", (XSObject)xSComplexTypeDefinition);
        this.sendElementEvent("psv:name", xSComplexTypeDefinition.getName());
        this.sendElementEvent("psv:targetNamespace", xSComplexTypeDefinition.getNamespace());
        this.processPSVITypeDefinitionOrRef("psv:baseTypeDefinition", xSComplexTypeDefinition.getBaseType());
        this.sendElementEvent("psv:derivationMethod", this.translateDerivation(xSComplexTypeDefinition.getDerivationMethod()));
        this.sendElementEvent("psv:final", this.translateFinal(xSComplexTypeDefinition.getFinal()));
        this.sendElementEvent("psv:abstract", String.valueOf(xSComplexTypeDefinition.getAbstract()));
        this.processPSVIAttributeUses(xSComplexTypeDefinition.getAttributeUses());
        this.processPSVIAttributeWildcard(xSComplexTypeDefinition.getAttributeWildcard());
        this.sendIndentedElement("psv:contentType");
        this.sendElementEvent("psv:variety", this.translateContentType(xSComplexTypeDefinition.getContentType()));
        this.processPSVISimpleTypeDefinition(xSComplexTypeDefinition.getSimpleType());
        this.processPSVIParticle(xSComplexTypeDefinition.getParticle());
        this.sendUnIndentedElement("psv:contentType");
        this.sendElementEvent("psv:prohibitedSubstitutions", this.translateFinal(xSComplexTypeDefinition.getProhibitedSubstitutions()));
        this.processPSVIAnnotations(xSComplexTypeDefinition.getAnnotations());
        this.sendUnIndentedElement("psv:complexTypeDefinition");
    }

    private void processPSVISimpleTypeDefinition(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (xSSimpleTypeDefinition == null) {
            return;
        }
        this.sendIndentedElementWithID("psv:simpleTypeDefinition", (XSObject)xSSimpleTypeDefinition);
        this.sendElementEvent("psv:name", xSSimpleTypeDefinition.getName());
        this.sendElementEvent("psv:targetNamespace", xSSimpleTypeDefinition.getNamespace());
        this.processPSVITypeDefinitionOrRef("psv:baseTypeDefinition", xSSimpleTypeDefinition.getBaseType());
        this.processPSVITypeDefinitionOrRef("psv:primitiveTypeDefinition", (XSTypeDefinition)xSSimpleTypeDefinition.getPrimitiveType());
        this.processPSVIFacets(xSSimpleTypeDefinition);
        this.sendIndentedElement("psv:fundamentalFacets");
        this.sendIndentedElement("psv:ordered");
        this.sendElementEvent("psv:value", this.translateOrdered(xSSimpleTypeDefinition.getOrdered()));
        this.sendUnIndentedElement("psv:ordered");
        this.sendIndentedElement("psv:bounded");
        this.sendElementEvent("psv:value", String.valueOf(xSSimpleTypeDefinition.getBounded()));
        this.sendUnIndentedElement("psv:bounded");
        this.sendIndentedElement("psv:cardinality");
        this.sendElementEvent("psv:value", String.valueOf(xSSimpleTypeDefinition.getFinite()));
        this.sendUnIndentedElement("psv:cardinality");
        this.sendIndentedElement("psv:numeric");
        this.sendElementEvent("psv:value", String.valueOf(xSSimpleTypeDefinition.getNumeric()));
        this.sendUnIndentedElement("psv:numeric");
        this.sendUnIndentedElement("psv:fundamentalFacets");
        this.sendElementEvent("psv:final", this.translateFinal(xSSimpleTypeDefinition.getFinal()));
        this.sendElementEvent("psv:variety", this.translateVariety(xSSimpleTypeDefinition.getVariety()));
        this.processPSVITypeDefinitionOrRef("psv:itemTypeDefinition", (XSTypeDefinition)xSSimpleTypeDefinition.getItemType());
        this.processPSVIMemberTypeDefinitions(xSSimpleTypeDefinition.getMemberTypes());
        this.processPSVIAnnotations(xSSimpleTypeDefinition.getAnnotations());
        this.sendUnIndentedElement("psv:simpleTypeDefinition");
    }

    private void processPSVIFacets(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (xSSimpleTypeDefinition == null) {
            return;
        }
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getFacets();
        XSObjectList xSObjectList2 = xSSimpleTypeDefinition.getMultiValueFacets();
        if (!(xSObjectList != null && xSObjectList.getLength() != 0 || xSObjectList2 != null && xSObjectList2.getLength() != 0)) {
            this.sendElementEvent("psv:facets");
        } else {
            String string;
            XSFacet xSFacet;
            int n;
            this.sendIndentedElement("psv:facets");
            if (xSObjectList != null) {
                n = 0;
                while (n < xSObjectList.getLength()) {
                    xSFacet = (XSFacet)xSObjectList.item(n);
                    string = this.translateFacetKind(xSFacet.getFacetKind());
                    this.sendIndentedElement("psv:" + string);
                    this.sendElementEvent("psv:value", xSFacet.getLexicalFacetValue());
                    this.sendElementEvent("psv:fixed", String.valueOf(xSFacet.isFixed()));
                    this.processPSVIAnnotation(xSFacet.getAnnotation());
                    this.sendUnIndentedElement("psv:" + string);
                    ++n;
                }
            }
            if (xSObjectList2 != null) {
                n = 0;
                while (n < xSObjectList2.getLength()) {
                    xSFacet = (XSMultiValueFacet)xSObjectList2.item(n);
                    string = this.translateFacetKind(xSFacet.getFacetKind());
                    this.sendIndentedElement("psv:" + string);
                    StringList stringList = xSFacet.getLexicalFacetValues();
                    int n2 = 0;
                    while (n2 < stringList.getLength()) {
                        this.sendElementEvent("psv:value", stringList.item(n2));
                        ++n2;
                    }
                    this.sendElementEvent("psv:fixed", "false");
                    this.processPSVIAnnotations(xSFacet.getAnnotations());
                    this.sendUnIndentedElement("psv:" + string);
                    ++n;
                }
            }
            this.sendUnIndentedElement("psv:facets");
        }
    }

    private void processPSVIMemberTypeDefinitions(XSObjectList xSObjectList) {
        if (xSObjectList == null || xSObjectList.getLength() == 0) {
            this.sendElementEvent("psv:memberTypeDefinitions");
        } else {
            this.sendIndentedElement("psv:memberTypeDefinitions");
            int n = 0;
            while (n < xSObjectList.getLength()) {
                this.processPSVITypeDefinitionOrRef("psv:memberTypeDefinition", (XSTypeDefinition)xSObjectList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:memberTypeDefinitions");
        }
    }

    private void processPSVIAnnotations(XSObjectList xSObjectList) {
        int n;
        boolean bl = true;
        if (xSObjectList != null && xSObjectList.getLength() > 0) {
            n = 0;
            while (n < xSObjectList.getLength()) {
                if (xSObjectList.item(n) != null) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            this.sendElementEvent("psv:annotations");
        } else {
            this.sendIndentedElement("psv:annotations");
            n = 0;
            while (n < xSObjectList.getLength()) {
                this.processPSVIAnnotation((XSAnnotation)xSObjectList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:annotations");
        }
    }

    private void processPSVISchemaAnnotations(XSObjectList xSObjectList) {
        if (xSObjectList == null || xSObjectList.getLength() == 0) {
            this.sendElementEvent("psv:schemaAnnotations");
        } else {
            this.sendIndentedElement("psv:schemaAnnotations");
            int n = 0;
            while (n < xSObjectList.getLength()) {
                this.processPSVIAnnotation((XSAnnotation)xSObjectList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:schemaAnnotations");
        }
    }

    private void processPSVIAttributeUses(XSObjectList xSObjectList) {
        if (xSObjectList == null || xSObjectList.getLength() == 0) {
            this.sendElementEvent("psv:attributeUses");
        } else {
            this.sendIndentedElement("psv:attributeUses");
            int n = 0;
            while (n < xSObjectList.getLength()) {
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(n);
                this.sendIndentedElement("psv:attributeUse");
                this.sendElementEvent("psv:required", String.valueOf(xSAttributeUse.getRequired()));
                this.processPSVIAttributeDeclarationOrRef(xSAttributeUse.getAttrDeclaration());
                this.sendElementEvent("psv:valueConstraint", xSAttributeUse.getConstraintValue());
                this.sendUnIndentedElement("psv:attributeUse");
                ++n;
            }
            this.sendUnIndentedElement("psv:attributeUses");
        }
    }

    private void processPSVIAttributeWildcard(XSWildcard xSWildcard) {
        if (xSWildcard == null) {
            this.sendElementEvent("psv:attributeWildcard");
        } else {
            this.sendIndentedElement("psv:attributeWildcard");
            this.processPSVIWildcard(xSWildcard);
            this.sendUnIndentedElement("psv:attributeWildcard");
        }
    }

    private void processPSVIWildcard(XSWildcard xSWildcard) {
        if (xSWildcard == null) {
            return;
        }
        this.sendIndentedElement("psv:wildcard");
        this.sendIndentedElement("psv:namespaceConstraint");
        this.sendElementEvent("psv:variety", this.translateConstraintType(xSWildcard.getConstraintType()));
        StringBuffer stringBuffer = new StringBuffer();
        StringList stringList = xSWildcard.getNsConstraintList();
        if (stringList != null && stringList.getLength() > 0) {
            int n = 0;
            while (n < stringList.getLength() - 1) {
                stringBuffer.append(stringList.item(n));
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(stringList.item(stringList.getLength() - 1));
        }
        this.sendElementEvent("psv:namespaces", stringBuffer.toString());
        this.sendUnIndentedElement("psv:namespaceConstraint");
        this.sendElementEvent("psv:processContents", this.translateProcessContents(xSWildcard.getProcessContents()));
        this.processPSVIAnnotation(xSWildcard.getAnnotation());
        this.sendUnIndentedElement("psv:wildcard");
    }

    private void processPSVIAnnotation(XSAnnotation xSAnnotation) {
        if (xSAnnotation == null) {
            this.sendElementEvent("psv:annotation");
        } else {
            this.sendIndentedElement("psv:annotation");
            DocumentImpl documentImpl = new DocumentImpl();
            xSAnnotation.writeAnnotation((Object)documentImpl, (short)2);
            Element element = DOMUtil.getFirstChildElement((Node)documentImpl);
            this.processDOMElement(element, SchemaSymbols.ELT_APPINFO, "psv:applicationInformation");
            this.processDOMElement(element, SchemaSymbols.ELT_DOCUMENTATION, "psv:userInformation");
            this.processDOMAttributes(element, "attributes");
            this.sendUnIndentedElement("psv:annotation");
        }
    }

    private void processDOMElement(Node node, String string, String string2) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        Element element = DOMUtil.getFirstChildElement((Node)node);
        while (element != null) {
            if (DOMUtil.getLocalName((Node)element).equals(string)) {
                if (!bl) {
                    this.sendIndentedElement(string2);
                    bl = true;
                }
                this.sendIndentedElement("element");
                this.sendElementEvent("namespaceName", DOMUtil.getNamespaceURI((Node)element));
                this.sendElementEvent("localName", DOMUtil.getLocalName((Node)element));
                this.sendElementEvent("prefix", element.getPrefix());
                this.sendIndentedElement("children");
                this.sendIndentedElement("character");
                this.sendElementEvent("textContent", DOMUtil.getChildText((Node)element));
                this.sendUnIndentedElement("character");
                this.sendUnIndentedElement("children");
                this.processDOMAttributes(element, "attributes");
                this.sendUnIndentedElement("element");
            }
            element = DOMUtil.getNextSiblingElement((Node)element);
        }
        if (bl) {
            this.sendUnIndentedElement(string2);
        } else {
            this.sendEmptyElementEvent(string2);
        }
    }

    private void processDOMAttributes(Element element, String string) {
        Attr[] attrArray;
        Attr[] attrArray2 = attrArray = element == null ? null : DOMUtil.getAttrs((Element)element);
        if (attrArray == null || attrArray.length == 0) {
            this.sendEmptyElementEvent(string);
        } else {
            this.sendIndentedElement(string);
            int n = 0;
            while (n < attrArray.length) {
                Attr attr = attrArray[n];
                this.sendIndentedElement("attribute");
                this.sendElementEvent("namespaceName", DOMUtil.getNamespaceURI((Node)attr));
                this.sendElementEvent("localName", DOMUtil.getLocalName((Node)attr));
                this.sendElementEvent("prefix", attr.getPrefix());
                this.sendElementEvent("normalizedValue", attr.getValue());
                this.sendElementEvent("specified", String.valueOf(attr.getSpecified()));
                this.sendElementEvent("attributeType");
                this.sendElementEvent("references");
                this.sendUnIndentedElement("attribute");
                ++n;
            }
            this.sendUnIndentedElement(string);
        }
    }

    private void processPSVIElementDeclaration(XSElementDeclaration xSElementDeclaration) {
        if (xSElementDeclaration == null) {
            return;
        }
        this.sendIndentedElementWithID("psv:elementDeclaration", (XSObject)xSElementDeclaration);
        this.sendElementEvent("psv:name", xSElementDeclaration.getName());
        this.sendElementEvent("psv:targetNamespace", xSElementDeclaration.getNamespace());
        this.processPSVITypeDefinitionOrRef("psv:typeDefinition", xSElementDeclaration.getTypeDefinition());
        this.sendElementEvent("psv:scope", this.translateScope(xSElementDeclaration.getScope()));
        this.sendElementEvent("psv:valueConstraint", xSElementDeclaration.getConstraintValue());
        this.sendElementEvent("psv:nillable", String.valueOf(xSElementDeclaration.getNillable()));
        this.processPSVIIdentityConstraintDefinitions(xSElementDeclaration.getIdentityConstraints());
        this.processPSVIElementRef("psv:substitutionGroupAffiliation", (XSObject)xSElementDeclaration.getSubstitutionGroupAffiliation());
        this.sendElementEvent("psv:substitutionGroupExclusions", this.translateFinal(xSElementDeclaration.getSubstitutionGroupExclusions()));
        this.sendElementEvent("psv:disallowedSubstitutions", this.translateFinal(xSElementDeclaration.getDisallowedSubstitutions()));
        this.sendElementEvent("psv:abstract", String.valueOf(xSElementDeclaration.getAbstract()));
        this.processPSVIAnnotation(xSElementDeclaration.getAnnotation());
        this.sendUnIndentedElement("psv:elementDeclaration");
    }

    private void processPSVIAttributeDeclaration(XSAttributeDeclaration xSAttributeDeclaration) {
        if (xSAttributeDeclaration == null) {
            return;
        }
        this.sendIndentedElementWithID("psv:attributeDeclaration", (XSObject)xSAttributeDeclaration);
        this.sendElementEvent("psv:name", xSAttributeDeclaration.getName());
        this.sendElementEvent("psv:targetNamespace", xSAttributeDeclaration.getNamespace());
        this.processPSVITypeDefinitionOrRef("psv:typeDefinition", (XSTypeDefinition)xSAttributeDeclaration.getTypeDefinition());
        this.sendElementEvent("psv:scope", this.translateScope(xSAttributeDeclaration.getScope()));
        this.sendElementEvent("psv:valueConstraint", xSAttributeDeclaration.getConstraintValue());
        this.processPSVIAnnotation(xSAttributeDeclaration.getAnnotation());
        this.sendUnIndentedElement("psv:attributeDeclaration");
    }

    private void processPSVIAttributeGroupDefinition(XSAttributeGroupDefinition xSAttributeGroupDefinition) {
        if (xSAttributeGroupDefinition == null) {
            return;
        }
        this.sendIndentedElementWithID("psv:attributeGroupDefinition", (XSObject)xSAttributeGroupDefinition);
        this.sendElementEvent("psv:name", xSAttributeGroupDefinition.getName());
        this.sendElementEvent("psv:targetNamespace", xSAttributeGroupDefinition.getNamespace());
        this.processPSVIAttributeUses(xSAttributeGroupDefinition.getAttributeUses());
        this.processPSVIAttributeWildcard(xSAttributeGroupDefinition.getAttributeWildcard());
        this.processPSVIAnnotation(xSAttributeGroupDefinition.getAnnotation());
        this.sendUnIndentedElement("psv:attributeGroupDefinition");
    }

    private void processPSVIModelGroupDefinition(XSModelGroupDefinition xSModelGroupDefinition) {
        if (xSModelGroupDefinition == null) {
            this.sendElementEvent("psv:modelGroupDefinition");
        } else {
            this.sendIndentedElementWithID("psv:modelGroupDefinition", (XSObject)xSModelGroupDefinition);
            this.sendElementEvent("psv:name", xSModelGroupDefinition.getName());
            this.sendElementEvent("psv:targetNamespace", xSModelGroupDefinition.getNamespace());
            this.processPSVIModelGroup(xSModelGroupDefinition.getModelGroup());
            this.processPSVIAnnotation(xSModelGroupDefinition.getAnnotation());
            this.sendUnIndentedElement("psv:modelGroupDefinition");
        }
    }

    private void processPSVIModelGroup(XSModelGroup xSModelGroup) {
        if (xSModelGroup == null) {
            this.sendElementEvent("psv:modelGroup");
        } else {
            this.sendIndentedElement("psv:modelGroup");
            this.sendElementEvent("psv:compositor", this.translateCompositor(xSModelGroup.getCompositor()));
            this.processPSVIParticles(xSModelGroup.getParticles());
            this.processPSVIAnnotation(xSModelGroup.getAnnotation());
            this.sendUnIndentedElement("psv:modelGroup");
        }
    }

    private void processPSVINotationDeclaration(XSNotationDeclaration xSNotationDeclaration) {
        if (xSNotationDeclaration == null) {
            this.sendElementEvent("psv:notationDeclaration");
        } else {
            this.sendIndentedElementWithID("psv:notationDeclaration", (XSObject)xSNotationDeclaration);
            this.sendElementEvent("psv:name", xSNotationDeclaration.getName());
            this.sendElementEvent("psv:targetNamespace", xSNotationDeclaration.getNamespace());
            this.sendElementEvent("systemIdentifier", xSNotationDeclaration.getSystemId());
            this.sendElementEvent("publicIdentifier", xSNotationDeclaration.getPublicId());
            this.processPSVIAnnotation(xSNotationDeclaration.getAnnotation());
            this.sendUnIndentedElement("psv:notationDeclaration");
        }
    }

    private void processPSVIIdentityConstraintDefinitions(XSNamedMap xSNamedMap) {
        if (xSNamedMap == null || xSNamedMap.getLength() == 0) {
            this.sendElementEvent("psv:identityConstraintDefinitions");
        } else {
            this.sendIndentedElement("psv:identityConstraintDefinitions");
            int n = 0;
            while (n < xSNamedMap.getLength()) {
                XSIDCDefinition xSIDCDefinition = (XSIDCDefinition)xSNamedMap.item(n);
                this.sendIndentedElementWithID("psv:identityConstraintDefinition", (XSObject)xSIDCDefinition);
                this.sendElementEvent("psv:name", xSIDCDefinition.getName());
                this.sendElementEvent("psv:targetNamespace", xSIDCDefinition.getNamespace());
                this.sendElementEvent("psv:identityConstraintCategory", this.translateCategory(xSIDCDefinition.getCategory()));
                this.sendIndentedElement("psv:selector");
                this.processPSVIXPath(xSIDCDefinition.getSelectorStr());
                this.sendUnIndentedElement("psv:selector");
                this.processPSVIFields(xSIDCDefinition.getFieldStrs());
                this.processPSVIElementRef("psv:referencedKey", (XSObject)xSIDCDefinition.getRefKey());
                this.processPSVIAnnotations(xSIDCDefinition.getAnnotations());
                this.sendUnIndentedElement("psv:identityConstraintDefinition");
                ++n;
            }
            this.sendUnIndentedElement("psv:identityConstraintDefinitions");
        }
    }

    private void processPSVIFields(StringList stringList) {
        if (stringList == null || stringList.getLength() == 0) {
            this.sendElementEvent("psv:fields");
        } else {
            this.sendIndentedElement("psv:fields");
            int n = 0;
            while (n < stringList.getLength()) {
                this.processPSVIXPath(stringList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:fields");
        }
    }

    private void processPSVIXPath(String string) {
        this.sendIndentedElement("psv:xpath");
        this.sendElementEvent("psv:xpath", string);
        this.sendUnIndentedElement("psv:xpath");
    }

    private void processPSVIParticles(XSObjectList xSObjectList) {
        if (xSObjectList == null || xSObjectList.getLength() == 0) {
            this.sendElementEvent("psv:particles");
        } else {
            this.sendIndentedElement("psv:particles");
            int n = 0;
            while (n < xSObjectList.getLength()) {
                this.processPSVIParticle((XSParticle)xSObjectList.item(n));
                ++n;
            }
            this.sendUnIndentedElement("psv:particles");
        }
    }

    private void processPSVIParticle(XSParticle xSParticle) {
        if (xSParticle == null) {
            this.sendElementEvent("psv:particle");
        } else {
            this.sendIndentedElement("psv:particle");
            this.sendElementEvent("psv:minOccurs", String.valueOf(xSParticle.getMinOccurs()));
            this.sendElementEvent("psv:maxOccurs", xSParticle.getMaxOccurs() == -1 ? "unbounded" : String.valueOf(xSParticle.getMaxOccurs()));
            this.sendIndentedElement("psv:term");
            switch (xSParticle.getTerm().getType()) {
                case 2: {
                    this.processPSVIElementDeclarationOrRef((XSElementDeclaration)xSParticle.getTerm());
                    break;
                }
                case 7: {
                    this.processPSVIModelGroup((XSModelGroup)xSParticle.getTerm());
                    break;
                }
                case 9: {
                    this.processPSVIWildcard((XSWildcard)xSParticle.getTerm());
                }
            }
            this.sendUnIndentedElement("psv:term");
            this.sendUnIndentedElement("psv:particle");
        }
    }

    private void processPSVIElementRef(String string, XSObject xSObject) {
        this.processPSVIElementRef(string, null, xSObject);
    }

    private void processPSVIElementRef(String string, Vector vector, XSObject xSObject) {
        String string2;
        if (vector == null) {
            vector = new Vector<String>();
        }
        if ((string2 = this.getID(xSObject)) != null) {
            vector.add("ref");
            vector.add(string2);
            vector.add(XMLSymbols.fIDREFSymbol);
        }
        this.sendElementEvent(string, vector, (XMLString)null);
    }

    private void processPSVIAttributeDeclarationOrRef(XSAttributeDeclaration xSAttributeDeclaration) {
        if (xSAttributeDeclaration == null) {
            return;
        }
        if (xSAttributeDeclaration.getScope() == 1 || this.fDefined.contains(this.getID((XSObject)xSAttributeDeclaration))) {
            this.processPSVIAttributeDeclarationRef(xSAttributeDeclaration);
        } else {
            this.processPSVIAttributeDeclaration(xSAttributeDeclaration);
        }
    }

    private void processPSVIAttributeDeclarationRef(XSAttributeDeclaration xSAttributeDeclaration) {
        if (xSAttributeDeclaration == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("name");
        vector.add(xSAttributeDeclaration.getName());
        vector.add(XMLSymbols.fCDATASymbol);
        if (xSAttributeDeclaration.getNamespace() != null) {
            vector.add("tns");
            vector.add(xSAttributeDeclaration.getNamespace());
            vector.add(XMLSymbols.fCDATASymbol);
        }
        this.processPSVIElementRef("psv:attributeDeclaration", vector, (XSObject)xSAttributeDeclaration);
    }

    private void processPSVITypeDefinitionRef(String string, XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return;
        }
        this.sendIndentedElement(string);
        if (xSTypeDefinition.getTypeCategory() == 13) {
            this.processPSVIElementRef("psv:complexTypeDefinition", (XSObject)xSTypeDefinition);
        } else if (xSTypeDefinition.getTypeCategory() == 14) {
            this.processPSVIElementRef("psv:simpleTypeDefinition", (XSObject)xSTypeDefinition);
        } else {
            throw new IllegalArgumentException("Unknown type definition value: " + xSTypeDefinition.getTypeCategory());
        }
        this.sendUnIndentedElement(string);
    }

    private void processPSVITypeDefinitionOrRef(String string, XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return;
        }
        if (xSTypeDefinition.getAnonymous() && !this.fDefined.contains(this.getID((XSObject)xSTypeDefinition))) {
            this.sendIndentedElement(string);
            this.processPSVITypeDefinition(xSTypeDefinition);
            this.sendUnIndentedElement(string);
        } else {
            this.processPSVITypeDefinitionRef(string, xSTypeDefinition);
        }
    }

    private void processPSVIElementDeclarationRef(XSElementDeclaration xSElementDeclaration) {
        if (xSElementDeclaration == null) {
            return;
        }
        this.processPSVIElementRef("psv:elementDeclaration", (XSObject)xSElementDeclaration);
    }

    private void processPSVIElementDeclarationOrRef(XSElementDeclaration xSElementDeclaration) {
        if (xSElementDeclaration == null) {
            return;
        }
        if (xSElementDeclaration.getScope() == 1 || this.fDefined.contains(this.getID((XSObject)xSElementDeclaration))) {
            this.processPSVIElementDeclarationRef(xSElementDeclaration);
        } else {
            this.processPSVIElementDeclaration(xSElementDeclaration);
        }
    }

    private void sendEmptyElementEvent(String string) {
        this.sendEmptyElementEvent(string, null);
    }

    private void sendEmptyElementEvent(String string, Vector vector) {
        this.sendIndent();
        this.fDocumentHandler.emptyElement(this.createQName(string), this.createAttributes(vector), null);
        this.sendNewLine();
    }

    private void sendStartElementEvent(String string, Vector vector) {
        this.fDocumentHandler.startElement(this.createQName(string), this.createAttributes(vector), null);
    }

    private void sendEndElementEvent(String string) {
        this.fDocumentHandler.endElement(this.createQName(string), null);
    }

    private void sendIndentedElement(String string) {
        this.sendIndentedElement(string, null);
    }

    private void sendIndentedElement(String string, Vector vector) {
        this.sendIndent();
        this.sendStartElementEvent(string, vector);
        this.sendNewLine();
        ++this.fIndent;
    }

    private void sendUnIndentedElement(String string) {
        --this.fIndent;
        this.sendIndent();
        this.sendEndElementEvent(string);
        this.sendNewLine();
    }

    private void sendElementEvent(String string) {
        this.sendElementEvent(string, null, (XMLString)null);
    }

    private void sendElementEvent(String string, String string2) {
        this.sendElementEvent(string, null, string2);
    }

    private void sendElementEvent(String string, XMLString xMLString) {
        this.sendElementEvent(string, null, xMLString);
    }

    private void sendElementEvent(String string, Vector vector, String string2) {
        XMLString xMLString = string2 == null ? null : new XMLString(string2.toCharArray(), 0, string2.length());
        this.sendElementEvent(string, vector, xMLString);
    }

    private void sendElementEvent(String string, Vector vector, XMLString xMLString) {
        if (xMLString == null || xMLString.equals("")) {
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.add("xsi:nil");
            vector.add("true");
            vector.add(XMLSymbols.fCDATASymbol);
            this.sendEmptyElementEvent(string, vector);
        } else {
            this.sendIndent();
            this.sendStartElementEvent(string, vector);
            this.fDocumentHandler.characters(xMLString, null);
            this.sendEndElementEvent(string);
            this.sendNewLine();
        }
    }

    private void sendIndentedElementWithID(String string, XSObject xSObject) {
        String string2 = this.getID(xSObject);
        this.fDefined.add(string2);
        Vector<String> vector = new Vector<String>();
        vector.add("id");
        vector.add(string2);
        vector.add(XMLSymbols.fIDSymbol);
        this.sendIndentedElement(string, vector);
    }

    private void sendIndent() {
        if (this.fIndent > this.fIndentChars.length) {
            this.fIndentChars = new char[this.fIndentChars.length * 2];
            int n = 0;
            while (n < this.fIndentChars.length) {
                this.fIndentChars[n] = 9;
                ++n;
            }
        }
        XMLString xMLString = new XMLString(this.fIndentChars, 0, this.fIndent);
        this.fDocumentHandler.characters(xMLString, null);
    }

    private void sendNewLine() {
        this.fDocumentHandler.characters(this.newLine, null);
    }

    private QName createQName(String string) {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n == -1) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        String string4 = this.fPSVINamespaceContext.getURI(string3);
        return new QName(string3, string2, string, string4);
    }

    private XMLAttributes createAttributes(Vector vector) {
        XMLAttributesImpl xMLAttributesImpl = new XMLAttributesImpl();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                String string2 = (String)vector.elementAt(n + 1);
                String string3 = (String)vector.elementAt(n + 2);
                xMLAttributesImpl.addAttribute(this.createQName(string), string3, string2);
                n += 3;
            }
        }
        return xMLAttributesImpl;
    }

    private String createID(XSObject xSObject) {
        String string = xSObject.getNamespace();
        String string2 = this.fNamespaceContext.getPrefix(xSObject.getNamespace());
        String string3 = xSObject.getName();
        String string4 = this.translateType(xSObject.getType());
        if (string3 == null) {
            string3 = "anon_" + this.fAnonNum++;
        } else if (string == null || string == XMLSymbols.EMPTY_STRING) {
            string3 = string3 + "." + this.fAnonNum++;
        }
        if (string == Constants.NS_XMLSCHEMA) {
            return string3;
        }
        return (string2 == null ? "" : string2 + ".") + string4 + "." + string3;
    }

    private String getID(XSObject xSObject) {
        if (xSObject == null) {
            return null;
        }
        String string = (String)this.fIDMap.get(xSObject);
        if (string == null) {
            string = this.createID(xSObject);
            this.fIDMap.put(xSObject, string);
        }
        return string;
    }

    private String translateType(short s) {
        switch (s) {
            case 3: {
                return "type";
            }
            case 12: {
                return "annot";
            }
            case 1: {
                return "attr";
            }
            case 5: {
                return "ag";
            }
            case 4: {
                return "au";
            }
            case 2: {
                return "elt";
            }
            case 6: {
                return "mg";
            }
            case 11: {
                return "not";
            }
            case 10: {
                return "idc";
            }
        }
        return "unknown";
    }

    private String translateFacetKind(short s) {
        switch (s) {
            case 16: {
                return SchemaSymbols.ELT_WHITESPACE;
            }
            case 1: {
                return SchemaSymbols.ELT_LENGTH;
            }
            case 2: {
                return SchemaSymbols.ELT_MINLENGTH;
            }
            case 4: {
                return SchemaSymbols.ELT_MAXLENGTH;
            }
            case 512: {
                return SchemaSymbols.ELT_TOTALDIGITS;
            }
            case 1024: {
                return SchemaSymbols.ELT_FRACTIONDIGITS;
            }
            case 8: {
                return SchemaSymbols.ELT_PATTERN;
            }
            case 2048: {
                return SchemaSymbols.ELT_ENUMERATION;
            }
            case 32: {
                return SchemaSymbols.ELT_MAXINCLUSIVE;
            }
            case 64: {
                return SchemaSymbols.ELT_MAXEXCLUSIVE;
            }
            case 128: {
                return SchemaSymbols.ELT_MINEXCLUSIVE;
            }
            case 256: {
                return SchemaSymbols.ELT_MININCLUSIVE;
            }
        }
        return "unknown";
    }

    private String translateVariety(short s) {
        switch (s) {
            case 2: {
                return "list";
            }
            case 3: {
                return "union";
            }
            case 1: {
                return "atomic";
            }
            case 0: {
                return null;
            }
        }
        return "unknown";
    }

    private String translateConstraintType(short s) {
        switch (s) {
            case 1: {
                return "any";
            }
            case 3: {
                return null;
            }
            case 2: {
                return "not";
            }
        }
        return "unknown";
    }

    private String translateFinal(short s) {
        String string = "";
        if ((s & 1) != 0) {
            string = string + SchemaSymbols.ELT_EXTENSION;
        }
        if ((s & 0x10) != 0) {
            if (string.length() != 0) {
                string = string + " ";
            }
            string = string + SchemaSymbols.ELT_LIST;
        }
        if ((s & 2) != 0) {
            if (string.length() != 0) {
                string = string + " ";
            }
            string = string + SchemaSymbols.ELT_RESTRICTION + " ";
        }
        if ((s & 8) != 0) {
            if (string.length() != 0) {
                string = string + " ";
            }
            string = string + SchemaSymbols.ELT_UNION + " ";
        }
        return string;
    }

    private String translateScope(short s) {
        switch (s) {
            case 0: {
                return null;
            }
            case 1: {
                return "global";
            }
            case 2: {
                return "local";
            }
        }
        return "unknown";
    }

    private String translateCompositor(short s) {
        switch (s) {
            case 1: {
                return SchemaSymbols.ELT_SEQUENCE;
            }
            case 2: {
                return SchemaSymbols.ELT_CHOICE;
            }
            case 3: {
                return SchemaSymbols.ELT_ALL;
            }
        }
        return "unknown";
    }

    private String translateContentType(short s) {
        switch (s) {
            case 2: {
                return "elementOnly";
            }
            case 0: {
                return "empty";
            }
            case 3: {
                return "mixed";
            }
            case 1: {
                return "simple";
            }
        }
        return "unknown";
    }

    private String translateProcessContents(short s) {
        switch (s) {
            case 3: {
                return "lax";
            }
            case 2: {
                return "skip";
            }
            case 1: {
                return "strict";
            }
        }
        return "unknown";
    }

    private String translateDerivation(short s) {
        switch (s) {
            case 1: {
                return SchemaSymbols.ELT_EXTENSION;
            }
            case 16: {
                return SchemaSymbols.ELT_LIST;
            }
            case 2: {
                return SchemaSymbols.ELT_RESTRICTION;
            }
            case 4: {
                return "substitution";
            }
            case 8: {
                return SchemaSymbols.ELT_UNION;
            }
            case 0: {
                return null;
            }
        }
        return "unknown";
    }

    private String translateCategory(short s) {
        switch (s) {
            case 1: {
                return SchemaSymbols.ELT_KEY;
            }
            case 2: {
                return SchemaSymbols.ELT_KEYREF;
            }
            case 3: {
                return SchemaSymbols.ELT_UNIQUE;
            }
        }
        return "unknown";
    }

    private String translateOrdered(short s) {
        switch (s) {
            case 0: {
                return "false";
            }
            case 1: {
                return "partial";
            }
            case 2: {
                return "total";
            }
        }
        return "unknown";
    }

    private String translateValidationAttempted(short s) {
        switch (s) {
            case 0: {
                return "none";
            }
            case 1: {
                return "partial";
            }
            case 2: {
                return "full";
            }
        }
        return "unknown";
    }

    private String translateValidity(short s) {
        switch (s) {
            case 0: {
                return "notKnown";
            }
            case 2: {
                return "valid";
            }
            case 1: {
                return "invalid";
            }
        }
        return "unknown";
    }

    private void checkForChildren() {
        if (!this._elementState.empty()) {
            ElementState elementState = (ElementState)this._elementState.peek();
            if (elementState.isEmpty) {
                this.sendIndentedElement("children");
                elementState.isEmpty = false;
            }
        } else {
            this.sendIndentedElement("children");
            this._elementState.push(new ElementState(false));
        }
    }

    class ElementState {
        public boolean isEmpty;
        XMLAttributes fAttributes;

        public ElementState(XMLAttributes xMLAttributes) {
            this.fAttributes = xMLAttributes;
            this.isEmpty = true;
        }

        public ElementState(boolean bl) {
            this.isEmpty = bl;
        }

        public XMLAttributes getAttributes() {
            return this.fAttributes;
        }

        public void isEmpty(boolean bl) {
            this.isEmpty = bl;
        }
    }
}

