/*
 * Decompiled with CFR 0.152.
 */
package xaf.clean.materialbadge;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import xaf.clean.materialbadge.R;

public class BadgedView
extends FrameLayout {
    private static final String DEF_BADGE_TEXT = "x";
    private static final int DEF_BADGE_TEXT_COLOR = -1;
    private static final int DEF_BADGE_TEXT_SIZE_SP = 10;
    private static final int DEF_BADGE_COLOR = -65536;
    private static final int DEF_OFFSET_X_DP = 4;
    private static final int DEF_OFFSET_Y_DP = 4;
    private static final int DEF_BADGE_SIZE_DP = 16;
    public static final int POSITION_START = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_END = 4;
    public static final int POSITION_BOTTOM = 8;
    private static final int DEF_POSITION = 6;
    public static final int SHAPE_HEXAGON = 0;
    public static final int SHAPE_ROMB = 1;
    public static final int SHAPE_SQUARE = 2;
    public static final int SHAPE_ROMB_FLUFF = 3;
    public static final int SHAPE_CIRCLE = 4;
    public static final int SHAPE_SQUARE_FLUFF = 5;
    public static final int SHAPE_OCTAGON = 6;
    public static final int SHAPE_STAR = 7;
    private static final int DEF_SHAPE = 4;
    private String badgeText;
    private int badgeTextColor;
    private float badgeTextSize;
    private int badgeColor;
    private float badgeSize;
    private float badgeOffsetX;
    private float badgeOffsetY;
    private int badgePosition;
    private int badgeShape;
    private boolean badgeIsVisible;
    private Paint bTextPaint;
    private Paint bBadgePaint;
    private float bCenterX;
    private float bCenterY;

    public BadgedView(Context context) {
        super(context);
        this.initAttributes(context, null, 0, 0);
    }

    public BadgedView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs, 0, 0);
    }

    public BadgedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public BadgedView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BadgedView, defStyleAttr, defStyleRes);
        try {
            this.badgeIsVisible = a.getBoolean(R.styleable.BadgedView_badgeIsVisible, true);
            this.badgeText = a.getString(R.styleable.BadgedView_badgeText) != null ? a.getString(R.styleable.BadgedView_badgeText) : DEF_BADGE_TEXT;
            this.badgeTextColor = a.getColor(R.styleable.BadgedView_badgeTextColor, -1);
            this.badgeTextSize = a.getDimension(R.styleable.BadgedView_badgeTextSize, TypedValue.applyDimension((int)2, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.badgeColor = a.getColor(R.styleable.BadgedView_badgeColor, -65536);
            this.badgeSize = a.getDimension(R.styleable.BadgedView_badgeSize, TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.badgeOffsetX = a.getDimension(R.styleable.BadgedView_badgeOffsetX, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.badgeOffsetY = a.getDimension(R.styleable.BadgedView_badgeOffsetY, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.badgePosition = a.getInt(R.styleable.BadgedView_badgePosition, 6);
            this.badgeShape = a.getInt(R.styleable.BadgedView_badgeShape, 4);
        }
        catch (Exception e) {
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)"initAttributes exception", (Throwable)e);
        }
        finally {
            a.recycle();
        }
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeIsVisible: " + String.valueOf(this.badgeIsVisible)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeText: " + String.valueOf(this.badgeText)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeTextColor: " + String.valueOf(this.badgeTextColor)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeTextSize: " + String.valueOf(this.badgeTextSize)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeColor: " + String.valueOf(this.badgeColor)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeSize: " + String.valueOf(this.badgeSize)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeOffsetX: " + String.valueOf(this.badgeOffsetX)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeOffsetY: " + String.valueOf(this.badgeOffsetY)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgePosition: " + String.valueOf(this.badgePosition)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("initAttributes, badgeShape: " + String.valueOf(this.badgeShape)));
        this.defineDrawingObjects();
        this.setWillNotDraw(false);
    }

    private void defineDrawingObjects() {
        this.bTextPaint = new Paint(1);
        this.bTextPaint.setColor(this.badgeTextColor);
        if (this.badgeTextSize == 0.0f) {
            this.badgeTextSize = this.bTextPaint.getTextSize();
        } else {
            this.bTextPaint.setTextSize(this.badgeTextSize);
        }
        this.bTextPaint.setTextAlign(Paint.Align.CENTER);
        this.bTextPaint.setTypeface(Typeface.DEFAULT);
        this.bBadgePaint = new Paint(1);
        this.bBadgePaint.setColor(this.badgeColor);
    }

    public String getBadgeText() {
        return this.badgeText;
    }

    public void setBadgeText(String badgeText) {
        this.badgeText = badgeText;
        this.invalidate();
        this.requestLayout();
    }

    public int getBadgeTextColor() {
        return this.badgeTextColor;
    }

    public void setBadgeTextColor(int badgeTextColor) {
        this.badgeTextColor = badgeTextColor;
        this.defineDrawingObjects();
        this.invalidate();
        this.requestLayout();
    }

    public int getBadgeColor() {
        return this.badgeColor;
    }

    public void setBadgeColor(int badgeColor) {
        this.badgeColor = badgeColor;
        this.defineDrawingObjects();
        this.invalidate();
        this.requestLayout();
    }

    public float getBadgeOffsetX() {
        return this.badgeOffsetX;
    }

    public void setBadgeOffsetX(float badgeOffsetX) {
        this.badgeOffsetX = badgeOffsetX;
        this.invalidate();
        this.requestLayout();
    }

    public float getBadgeOffsetY() {
        return this.badgeOffsetY;
    }

    public void setBadgeOffsetY(float badgeOffsetY) {
        this.badgeOffsetY = badgeOffsetY;
        this.invalidate();
        this.requestLayout();
    }

    public int getBadgePosition() {
        return this.badgePosition;
    }

    public void setBadgePosition(int badgePosition) {
        this.badgePosition = badgePosition;
        this.invalidate();
        this.requestLayout();
    }

    public int getBadgeShape() {
        return this.badgeShape;
    }

    public void setBadgeShape(int badgeShape) {
        this.badgeShape = badgeShape;
        this.invalidate();
        this.requestLayout();
    }

    public float getBadgeSize() {
        return this.badgeSize;
    }

    public void setBadgeSize(float badgeSize) {
        this.badgeSize = badgeSize;
        this.invalidate();
        this.requestLayout();
    }

    public boolean isBadgeVisible() {
        return this.badgeIsVisible;
    }

    public void setBadgeVisible(boolean badgeIsVisible) {
        this.badgeIsVisible = badgeIsVisible;
        this.invalidate();
        this.requestLayout();
    }

    private boolean isRTL() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("onSizeChanged, w: " + String.valueOf(w) + ", h: " + String.valueOf(h)));
        if ((this.badgePosition & 1) == 1) {
            this.bCenterX = !this.isRTL() ? 0.0f - this.badgeOffsetX : (float)w + this.badgeOffsetX;
        } else if ((this.badgePosition & 4) == 4) {
            float f = this.bCenterX = this.isRTL() ? 0.0f - this.badgeOffsetX : (float)w + this.badgeOffsetX;
        }
        if ((this.badgePosition & 2) == 2) {
            this.bCenterY = 0.0f - this.badgeOffsetY;
        } else if ((this.badgePosition & 8) == 8) {
            this.bCenterY = (float)h + this.badgeOffsetY;
        }
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("onSizeChanged, bCenterX: " + String.valueOf(this.bCenterX) + ", bCenterY: " + String.valueOf(this.bCenterY)));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("onDraw, bCenterX: " + String.valueOf(this.bCenterX) + ", bCenterY: " + String.valueOf(this.bCenterY)));
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("onDraw, badgeIsVisible: " + String.valueOf(this.badgeIsVisible)));
        Rect boundsRect = canvas.getClipBounds();
        boundsRect.inset(-((int)(this.badgeSize + this.badgeOffsetX)), -((int)(this.badgeSize + this.badgeOffsetY)));
        canvas.clipRect(boundsRect, Region.Op.REPLACE);
        if (this.badgeIsVisible) {
            switch (this.badgeShape) {
                case 1: {
                    canvas.save();
                    canvas.rotate(45.0f, this.bCenterX, this.bCenterY);
                    if (Build.VERSION.SDK_INT >= 21) {
                        canvas.drawRoundRect(this.bCenterX - this.badgeSize / 2.0f, this.bCenterY - this.badgeSize / 2.0f, this.bCenterX + this.badgeSize / 2.0f, this.bCenterY + this.badgeSize / 2.0f, this.badgeSize / 4.0f, this.badgeSize / 4.0f, this.bBadgePaint);
                    } else {
                        canvas.drawRect(this.bCenterX - this.badgeSize / 2.0f, this.bCenterY - this.badgeSize / 2.0f, this.bCenterX + this.badgeSize / 2.0f, this.bCenterY + this.badgeSize / 2.0f, this.bBadgePaint);
                    }
                    canvas.restore();
                    break;
                }
                case 2: {
                    if (Build.VERSION.SDK_INT >= 21) {
                        canvas.drawRoundRect(this.bCenterX - this.badgeSize / 2.0f, this.bCenterY - this.badgeSize / 2.0f, this.bCenterX + this.badgeSize / 2.0f, this.bCenterY + this.badgeSize / 2.0f, this.badgeSize / 4.0f, this.badgeSize / 4.0f, this.bBadgePaint);
                        break;
                    }
                    canvas.drawRect(this.bCenterX - this.badgeSize / 2.0f, this.bCenterY - this.badgeSize / 2.0f, this.bCenterX + this.badgeSize / 2.0f, this.bCenterY + this.badgeSize / 2.0f, this.bBadgePaint);
                    break;
                }
                case 4: {
                    canvas.drawCircle(this.bCenterX, this.bCenterY, this.badgeSize / 2.0f, this.bBadgePaint);
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong shape value: " + String.valueOf(this.badgeShape));
                }
            }
            canvas.drawText(this.badgeText, this.bCenterX, this.bCenterY - (this.bTextPaint.descent() + this.bTextPaint.ascent()) / 2.0f, this.bTextPaint);
        }
    }
}

