/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.config;

import java.io.File;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import x.aichen.http.RetrofitManager;
import x.aichen.http.interceptor.OfflineCacheInterceptor;
import x.aichen.http.interceptor.OnlineCacheInterceptor;

public class HttpGlobalConfig {
    private CallAdapter.Factory callAdapterFactory;
    private Converter.Factory converterFactory;
    private Call.Factory callFactory;
    private ConnectionPool connectionPool;
    private File httpCacheDirectory;
    private int retryDelayMillis;
    private int retryCount;
    private Long CACHE_MAX_SIZE;
    private boolean isHttpCache;
    private Cache httpCache;
    private static HttpGlobalConfig instance;

    public HttpGlobalConfig retryDelayMillis(int retryDelayMillis) {
        this.retryDelayMillis = retryDelayMillis;
        return this;
    }

    public HttpGlobalConfig retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public HttpGlobalConfig httpCache(Cache httpCache) {
        this.httpCache = httpCache;
        return this;
    }

    public boolean isHttpCache() {
        return this.isHttpCache;
    }

    public HttpGlobalConfig UseHttpCache(boolean isHttpCache) {
        this.isHttpCache = isHttpCache;
        return this;
    }

    public Long getCacheMaxSize() {
        return this.CACHE_MAX_SIZE;
    }

    public HttpGlobalConfig CacheMaxSize(Long cache_max_size) {
        this.CACHE_MAX_SIZE = cache_max_size;
        return this;
    }

    private HttpGlobalConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpGlobalConfig getInstance() {
        if (instance != null) return instance;
        Class<HttpGlobalConfig> clazz = HttpGlobalConfig.class;
        synchronized (HttpGlobalConfig.class) {
            if (instance != null) return instance;
            instance = new HttpGlobalConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public HttpGlobalConfig callAdapterFactory(CallAdapter.Factory factory) {
        this.callAdapterFactory = factory;
        return this;
    }

    public HttpGlobalConfig converterFactory(Converter.Factory factory) {
        this.converterFactory = factory;
        return this;
    }

    public HttpGlobalConfig callFactory(Call.Factory factory) {
        this.callFactory = this.checkNotNull(factory, "factory == null");
        return this;
    }

    public HttpGlobalConfig connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = this.checkNotNull(connectionPool, "connectionPool == null");
        return this;
    }

    public HttpGlobalConfig httpCacheDirectory(File httpCacheDirectory) {
        this.httpCacheDirectory = httpCacheDirectory;
        return this;
    }

    public HttpGlobalConfig proxy(Proxy proxy) {
        RetrofitManager.getOkHttpBuilder2().proxy(this.checkNotNull(proxy, "proxy == null"));
        return this;
    }

    public HttpGlobalConfig connectTimeout(int timeout) {
        return this.connectTimeout(timeout, TimeUnit.SECONDS);
    }

    public HttpGlobalConfig readTimeout(int timeout) {
        return this.readTimeout(timeout, TimeUnit.SECONDS);
    }

    public HttpGlobalConfig writeTimeout(int timeout) {
        return this.writeTimeout(timeout, TimeUnit.SECONDS);
    }

    public HttpGlobalConfig connectTimeout(int timeout, TimeUnit unit) {
        if (timeout > -1) {
            RetrofitManager.getOkHttpBuilder2().connectTimeout((long)timeout, unit);
        } else {
            RetrofitManager.getOkHttpBuilder2().connectTimeout(90L, TimeUnit.SECONDS);
        }
        return this;
    }

    public HttpGlobalConfig writeTimeout(int timeout, TimeUnit unit) {
        if (timeout > -1) {
            RetrofitManager.getOkHttpBuilder2().writeTimeout((long)timeout, unit);
        } else {
            RetrofitManager.getOkHttpBuilder2().writeTimeout(90L, TimeUnit.SECONDS);
        }
        return this;
    }

    public HttpGlobalConfig readTimeout(int timeout, TimeUnit unit) {
        if (timeout > -1) {
            RetrofitManager.getOkHttpBuilder2().readTimeout((long)timeout, unit);
        } else {
            RetrofitManager.getOkHttpBuilder2().readTimeout(90L, TimeUnit.SECONDS);
        }
        return this;
    }

    public HttpGlobalConfig interceptor(Interceptor interceptor) {
        RetrofitManager.getOkHttpBuilder2().addInterceptor(this.checkNotNull(interceptor, "interceptor == null"));
        return this;
    }

    public HttpGlobalConfig networkInterceptor(Interceptor interceptor) {
        RetrofitManager.getOkHttpBuilder2().addNetworkInterceptor(this.checkNotNull(interceptor, "interceptor == null"));
        return this;
    }

    public HttpGlobalConfig cacheOnline(Cache httpCache) {
        this.networkInterceptor(new OnlineCacheInterceptor());
        this.httpCache = httpCache;
        return this;
    }

    public HttpGlobalConfig cacheOffline(Cache httpCache) {
        this.networkInterceptor(new OfflineCacheInterceptor());
        this.interceptor(new OfflineCacheInterceptor());
        this.httpCache = httpCache;
        return this;
    }

    public CallAdapter.Factory getCallAdapterFactory() {
        return this.callAdapterFactory;
    }

    public Converter.Factory getConverterFactory() {
        return this.converterFactory;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public int getRetryDelayMillis() {
        if (this.retryDelayMillis <= 0) {
            this.retryDelayMillis = 3000;
        }
        return this.retryDelayMillis;
    }

    public Cache getHttpCache() {
        return this.httpCache;
    }

    public int getRetryCount() {
        if (this.retryCount <= 0) {
            this.retryCount = 3;
        }
        return this.retryCount;
    }

    public File getHttpCacheDirectory() {
        return this.httpCacheDirectory;
    }

    private <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }
}

